/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.support;

import cn.taketoday.aop.MethodMatcher;
import cn.taketoday.aop.Pointcut;
import cn.taketoday.aop.proxy.DefaultMethodInvocation;
import cn.taketoday.aop.support.AopUtils;
import cn.taketoday.aop.support.ComposablePointcut;
import cn.taketoday.aop.support.StaticMethodMatcherPointcut;
import cn.taketoday.context.utils.Assert;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;

public abstract class Pointcuts {
    public static final Pointcut SETTERS = SetterPointcut.INSTANCE;
    public static final Pointcut GETTERS = GetterPointcut.INSTANCE;

    public static Pointcut union(Pointcut pc1, Pointcut pc2) {
        return new ComposablePointcut(pc1).union(pc2);
    }

    public static Pointcut intersection(Pointcut pc1, Pointcut pc2) {
        return new ComposablePointcut(pc1).intersection(pc2);
    }

    public static boolean matches(Pointcut pointcut, MethodInvocation invocation) {
        MethodMatcher mm;
        Assert.notNull((Object)pointcut, "Pointcut must not be null");
        if (pointcut == Pointcut.TRUE) {
            return true;
        }
        Class<?> targetClass = AopUtils.getTargetClass(invocation);
        if (pointcut.getClassFilter().matches(targetClass) && (mm = pointcut.getMethodMatcher()).matches(invocation.getMethod(), targetClass)) {
            return !mm.isRuntime() || mm.matches(invocation);
        }
        return false;
    }

    public static boolean matches(Pointcut pointcut, Method method, Class<?> targetClass, Object ... args) {
        MethodMatcher mm;
        Assert.notNull((Object)pointcut, "Pointcut must not be null");
        if (pointcut == Pointcut.TRUE) {
            return true;
        }
        if (pointcut.getClassFilter().matches(targetClass) && (mm = pointcut.getMethodMatcher()).matches(method, targetClass)) {
            return !mm.isRuntime() || mm.matches(new DefaultMethodInvocation(method, targetClass, args));
        }
        return false;
    }

    static class GetterPointcut
    extends StaticMethodMatcherPointcut
    implements Serializable {
        public static final GetterPointcut INSTANCE = new GetterPointcut();

        GetterPointcut() {
        }

        @Override
        public boolean matches(Method method, Class<?> targetClass) {
            return method.getName().startsWith("get") && method.getParameterCount() == 0;
        }

        private Object readResolve() {
            return INSTANCE;
        }

        public String toString() {
            return "Pointcuts.GETTERS";
        }
    }

    static class SetterPointcut
    extends StaticMethodMatcherPointcut
    implements Serializable {
        public static final SetterPointcut INSTANCE = new SetterPointcut();

        SetterPointcut() {
        }

        @Override
        public boolean matches(Method method, Class<?> targetClass) {
            return method.getName().startsWith("set") && method.getParameterCount() == 1 && method.getReturnType() == Void.TYPE;
        }

        private Object readResolve() {
            return INSTANCE;
        }

        public String toString() {
            return "Pointcuts.SETTERS";
        }
    }
}

