/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.support;

import cn.taketoday.aop.Advisor;
import cn.taketoday.aop.AfterReturningAdvice;
import cn.taketoday.aop.AopInvocationException;
import cn.taketoday.aop.IntroductionAdvisor;
import cn.taketoday.aop.IntroductionAwareMethodMatcher;
import cn.taketoday.aop.MethodBeforeAdvice;
import cn.taketoday.aop.MethodMatcher;
import cn.taketoday.aop.Pointcut;
import cn.taketoday.aop.PointcutAdvisor;
import cn.taketoday.aop.TargetClassAware;
import cn.taketoday.aop.ThrowsAdvice;
import cn.taketoday.aop.proxy.Advised;
import cn.taketoday.aop.proxy.AdvisedSupport;
import cn.taketoday.aop.proxy.AdvisorAdapter;
import cn.taketoday.aop.proxy.AopConfigException;
import cn.taketoday.aop.proxy.AopProxy;
import cn.taketoday.aop.proxy.CglibAopProxy;
import cn.taketoday.aop.proxy.JdkDynamicAopProxy;
import cn.taketoday.aop.proxy.StandardAopProxy;
import cn.taketoday.aop.proxy.StandardProxy;
import cn.taketoday.aop.proxy.UnknownAdviceTypeException;
import cn.taketoday.aop.support.DefaultPointcutAdvisor;
import cn.taketoday.aop.support.RuntimeMethodInterceptor;
import cn.taketoday.context.Ordered;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.OrderUtils;
import cn.taketoday.context.utils.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public abstract class AopUtils {
    public static final MethodInterceptor[] EMPTY_INTERCEPTOR = new MethodInterceptor[0];
    private static final List<AdvisorAdapter> advisorAdapters = new ArrayList<AdvisorAdapter>();

    public static boolean isAopProxy(Object object) {
        return object instanceof StandardProxy && (Proxy.isProxyClass(object.getClass()) || object.getClass().getName().contains("$$"));
    }

    public static boolean isJdkDynamicProxy(Object object) {
        return object instanceof StandardProxy && Proxy.isProxyClass(object.getClass());
    }

    public static boolean isCglibProxy(Object object) {
        return object instanceof StandardProxy && object.getClass().getName().contains("$$");
    }

    public static Class<?> getTargetClass(Object candidate) {
        Assert.notNull(candidate, "Candidate object must not be null");
        Class<?> result = null;
        if (candidate instanceof TargetClassAware) {
            result = ((TargetClassAware)candidate).getTargetClass();
        }
        if (result == null) {
            result = AopUtils.isCglibProxy(candidate) ? candidate.getClass().getSuperclass() : candidate.getClass();
        }
        return result;
    }

    public static Class<?> getTargetClass(MethodInvocation invocation) {
        Assert.notNull((Object)invocation, "MethodInvocation must not be null");
        Class<?> result = null;
        if (invocation instanceof TargetClassAware) {
            result = ((TargetClassAware)((Object)invocation)).getTargetClass();
        }
        if (result == null) {
            result = AopUtils.getTargetClass(invocation.getThis());
        }
        return result;
    }

    public static boolean canApply(Pointcut pc, Class<?> targetClass) {
        return AopUtils.canApply(pc, targetClass, false);
    }

    public static boolean canApply(Pointcut pc, Class<?> targetClass, boolean hasIntroductions) {
        Assert.notNull((Object)pc, "Pointcut must not be null");
        if (!pc.getClassFilter().matches(targetClass)) {
            return false;
        }
        MethodMatcher methodMatcher = pc.getMethodMatcher();
        if (methodMatcher == MethodMatcher.TRUE) {
            return true;
        }
        IntroductionAwareMethodMatcher introductionAwareMethodMatcher = null;
        if (methodMatcher instanceof IntroductionAwareMethodMatcher) {
            introductionAwareMethodMatcher = (IntroductionAwareMethodMatcher)methodMatcher;
        }
        LinkedHashSet classes = new LinkedHashSet();
        if (!Proxy.isProxyClass(targetClass)) {
            classes.add(ClassUtils.getUserClass(targetClass));
        }
        classes.addAll(ClassUtils.getAllInterfacesForClassAsSet(targetClass));
        for (Class clazz : classes) {
            Method[] methods;
            for (Method method : methods = ReflectionUtils.getAllDeclaredMethods(clazz)) {
                if (!(introductionAwareMethodMatcher != null ? introductionAwareMethodMatcher.matches(method, targetClass, hasIntroductions) : methodMatcher.matches(method, targetClass))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canApply(Advisor advisor, Class<?> targetClass) {
        return AopUtils.canApply(advisor, targetClass, false);
    }

    public static boolean canApply(Advisor advisor, Class<?> targetClass, boolean hasIntroductions) {
        if (advisor instanceof IntroductionAdvisor) {
            return ((IntroductionAdvisor)advisor).getClassFilter().matches(targetClass);
        }
        if (advisor instanceof PointcutAdvisor) {
            PointcutAdvisor pca = (PointcutAdvisor)advisor;
            return AopUtils.canApply(pca.getPointcut(), targetClass, hasIntroductions);
        }
        return true;
    }

    public static List<Advisor> filterAdvisors(List<Advisor> candidateAdvisors, Class<?> clazz) {
        if (candidateAdvisors.isEmpty()) {
            return candidateAdvisors;
        }
        ArrayList<Advisor> eligibleAdvisors = new ArrayList<Advisor>();
        for (Advisor candidate : candidateAdvisors) {
            if (!(candidate instanceof IntroductionAdvisor) || !AopUtils.canApply(candidate, clazz)) continue;
            eligibleAdvisors.add(candidate);
        }
        boolean hasIntroductions = !eligibleAdvisors.isEmpty();
        for (Advisor candidate : candidateAdvisors) {
            if (candidate instanceof IntroductionAdvisor || !AopUtils.canApply(candidate, clazz, hasIntroductions)) continue;
            eligibleAdvisors.add(candidate);
        }
        return eligibleAdvisors;
    }

    public static Object invokeJoinpointUsingReflection(Object target, Method method, Object[] args) throws Throwable {
        try {
            ReflectionUtils.makeAccessible(method);
            return method.invoke(target, args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
        catch (IllegalArgumentException ex) {
            throw new AopInvocationException("AOP configuration seems to be invalid: tried calling method [" + method + "] on target [" + target + "]", ex);
        }
        catch (IllegalAccessException ex) {
            throw new AopInvocationException("Could not access method [" + method + "]", ex);
        }
    }

    public static MethodInterceptor[] getInterceptorsArray(Advised config, Method method, Class<?> targetClass) {
        List<MethodInterceptor> interceptors = AopUtils.getInterceptors(config, method, targetClass);
        if (interceptors.isEmpty()) {
            return EMPTY_INTERCEPTOR;
        }
        return interceptors.toArray(new MethodInterceptor[interceptors.size()]);
    }

    public static List<MethodInterceptor> getInterceptors(Advised config, Method method, Class<?> targetClass) {
        Advisor[] advisors = config.getAdvisors();
        ArrayList<MethodInterceptor> ret = new ArrayList<MethodInterceptor>(advisors.length);
        Class<?> actualClass = targetClass != null ? targetClass : method.getDeclaringClass();
        Boolean hasIntroductions = null;
        for (Advisor advisor : advisors) {
            if (advisor instanceof PointcutAdvisor) {
                boolean match;
                PointcutAdvisor pointcutAdvisor = (PointcutAdvisor)advisor;
                if (!config.isPreFiltered() && !pointcutAdvisor.getPointcut().getClassFilter().matches(actualClass)) continue;
                MethodMatcher matcher = pointcutAdvisor.getPointcut().getMethodMatcher();
                if (matcher instanceof IntroductionAwareMethodMatcher) {
                    if (hasIntroductions == null) {
                        hasIntroductions = AopUtils.hasMatchingIntroductions(advisors, actualClass);
                    }
                    match = ((IntroductionAwareMethodMatcher)matcher).matches(method, actualClass, hasIntroductions);
                } else {
                    match = matcher.matches(method, actualClass);
                }
                if (!match) continue;
                MethodInterceptor[] interceptors = AopUtils.getInterceptors(advisor);
                if (matcher.isRuntime()) {
                    for (MethodInterceptor interceptor : interceptors) {
                        ret.add(new RuntimeMethodInterceptor(interceptor, matcher));
                    }
                    continue;
                }
                Collections.addAll(ret, interceptors);
                continue;
            }
            if (advisor instanceof IntroductionAdvisor) {
                IntroductionAdvisor ia = (IntroductionAdvisor)advisor;
                if (!config.isPreFiltered() && !ia.getClassFilter().matches(actualClass)) continue;
                MethodInterceptor[] interceptors = AopUtils.getInterceptors(advisor);
                Collections.addAll(ret, interceptors);
                continue;
            }
            MethodInterceptor[] interceptors = AopUtils.getInterceptors(advisor);
            Collections.addAll(ret, interceptors);
        }
        return ret;
    }

    public static Advisor wrap(Object adviceObject) throws UnknownAdviceTypeException {
        if (adviceObject instanceof Advisor) {
            return (Advisor)adviceObject;
        }
        if (adviceObject instanceof Advice) {
            Advice advice = (Advice)adviceObject;
            if (advice instanceof MethodInterceptor) {
                return new DefaultPointcutAdvisor(advice);
            }
            for (AdvisorAdapter adapter : advisorAdapters) {
                if (!adapter.supportsAdvice(advice)) continue;
                return new DefaultPointcutAdvisor(advice);
            }
        }
        throw new UnknownAdviceTypeException(adviceObject);
    }

    public static MethodInterceptor[] getInterceptors(Advisor advisor) throws UnknownAdviceTypeException {
        ArrayList<MethodInterceptor> interceptors = new ArrayList<MethodInterceptor>(3);
        Advice advice = advisor.getAdvice();
        if (advice instanceof MethodInterceptor) {
            interceptors.add((MethodInterceptor)advice);
        }
        for (AdvisorAdapter adapter : advisorAdapters) {
            if (!adapter.supportsAdvice(advice)) continue;
            interceptors.add(adapter.getInterceptor(advisor));
        }
        if (interceptors.isEmpty()) {
            throw new UnknownAdviceTypeException(advisor.getAdvice());
        }
        return interceptors.toArray(new MethodInterceptor[0]);
    }

    private static boolean hasMatchingIntroductions(Advisor[] advisors, Class<?> actualClass) {
        for (Advisor advisor : advisors) {
            IntroductionAdvisor ia;
            if (!(advisor instanceof IntroductionAdvisor) || !(ia = (IntroductionAdvisor)advisor).getClassFilter().matches(actualClass)) continue;
            return true;
        }
        return false;
    }

    public static AopProxy createAopProxy(AdvisedSupport config) throws AopConfigException {
        if (config.isOptimize() || config.isProxyTargetClass() || AopUtils.hasNoUserSuppliedProxyInterfaces(config)) {
            Class<?> targetClass = config.getTargetClass();
            if (targetClass == null) {
                throw new AopConfigException("TargetSource cannot determine target class: Either an interface or a target is required for proxy creation.");
            }
            if (targetClass.isInterface() || Proxy.isProxyClass(targetClass)) {
                return new JdkDynamicAopProxy(config);
            }
            if (config.isUsingCglib()) {
                return new CglibAopProxy(config);
            }
            return new StandardAopProxy(config);
        }
        return new JdkDynamicAopProxy(config);
    }

    private static boolean hasNoUserSuppliedProxyInterfaces(AdvisedSupport config) {
        Class<?>[] ifcs = config.getProxiedInterfaces();
        return ifcs.length == 0 || ifcs.length == 1 && StandardProxy.class.isAssignableFrom(ifcs[0]);
    }

    public static void addAdvisorAdapters(AdvisorAdapter ... adapters) {
        Collections.addAll(advisorAdapters, adapters);
        OrderUtils.reversedSort(advisorAdapters);
    }

    static {
        AopUtils.addAdvisorAdapters(new BeforeAdvisorAdapter(), new ThrowsAdviceAdvisorAdapter(), new AfterReturningAdvisorAdapter());
    }

    static final class ThrowsAdviceAdvisorAdapter
    implements AdvisorAdapter {
        ThrowsAdviceAdvisorAdapter() {
        }

        @Override
        public boolean supportsAdvice(Advice advice) {
            return advice instanceof ThrowsAdvice;
        }

        @Override
        public MethodInterceptor getInterceptor(Advisor advisor) {
            final ThrowsAdvice advice = (ThrowsAdvice)advisor.getAdvice();
            final class Interceptor
            implements MethodInterceptor,
            Ordered {
                Interceptor() {
                }

                @Override
                public Object invoke(MethodInvocation invocation) throws Throwable {
                    try {
                        return invocation.proceed();
                    }
                    catch (Throwable ex) {
                        return advice.afterThrowing(ex, invocation);
                    }
                }

                @Override
                public int getOrder() {
                    return 5;
                }
            }
            return new Interceptor();
        }
    }

    static final class AfterReturningAdvisorAdapter
    implements AdvisorAdapter {
        AfterReturningAdvisorAdapter() {
        }

        @Override
        public boolean supportsAdvice(Advice advice) {
            return advice instanceof AfterReturningAdvice;
        }

        @Override
        public MethodInterceptor getInterceptor(Advisor advisor) {
            final AfterReturningAdvice advice = (AfterReturningAdvice)advisor.getAdvice();
            final class Interceptor
            implements MethodInterceptor,
            Ordered {
                Interceptor() {
                }

                @Override
                public Object invoke(MethodInvocation invocation) throws Throwable {
                    Object returnValue = invocation.proceed();
                    advice.afterReturning(returnValue, invocation);
                    return returnValue;
                }

                @Override
                public int getOrder() {
                    return 4;
                }
            }
            return new Interceptor();
        }
    }

    static final class BeforeAdvisorAdapter
    implements AdvisorAdapter {
        BeforeAdvisorAdapter() {
        }

        @Override
        public boolean supportsAdvice(Advice advice) {
            return advice instanceof MethodBeforeAdvice;
        }

        @Override
        public MethodInterceptor getInterceptor(Advisor advisor) {
            final MethodBeforeAdvice advice = (MethodBeforeAdvice)advisor.getAdvice();
            final class Interceptor
            implements MethodInterceptor,
            Ordered {
                Interceptor() {
                }

                @Override
                public Object invoke(MethodInvocation invocation) throws Throwable {
                    advice.before(invocation);
                    return invocation.proceed();
                }

                @Override
                public int getOrder() {
                    return 2;
                }
            }
            return new Interceptor();
        }
    }
}

