/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.proxy.std;

import cn.taketoday.aop.TargetSource;
import cn.taketoday.aop.proxy.AdvisedSupport;
import cn.taketoday.aop.proxy.StandardProxyInvoker;
import cn.taketoday.aop.proxy.TargetInvocation;
import cn.taketoday.aop.proxy.std.GeneratorContext;
import cn.taketoday.aop.proxy.std.ProxyMethodGenerator;
import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.CglibReflectUtils;
import cn.taketoday.context.cglib.core.ClassEmitter;
import cn.taketoday.context.cglib.core.CodeEmitter;
import cn.taketoday.context.cglib.core.CodeGenerationException;
import cn.taketoday.context.cglib.core.EmitUtils;
import cn.taketoday.context.cglib.core.Local;
import cn.taketoday.context.cglib.core.MethodInfo;
import cn.taketoday.context.cglib.core.Signature;
import cn.taketoday.context.utils.StringUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;

public class DefaultProxyMethodGenerator
implements ProxyMethodGenerator {
    private static final Signature proceed;
    private static final Signature dynamicProceed;
    private static final Signature staticExposeProceed;
    private static final Signature dynamicExposeProceed;
    private static final Signature dynamicAdvisedProceed;
    private static final Type stdProxyInvoker;
    private static final Type targetInvocationType;

    @Override
    public boolean generate(Method method, GeneratorContext context) {
        List<String> fields = context.getFields();
        String targetInvField = this.putTargetInv(method, context, fields);
        context.addField(targetInvField);
        ClassEmitter classEmitter = context.getClassEmitter();
        classEmitter.declare_field(this.getStaticAccess(), targetInvField, targetInvocationType, null);
        MethodInfo methodInfo = CglibReflectUtils.getMethodInfo(method);
        int modifiers = method.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            modifiers -= 1024;
        }
        CodeEmitter codeEmitter = EmitUtils.beginMethod(classEmitter, methodInfo, modifiers);
        this.generateProxyMethod(method, targetInvField, context, codeEmitter);
        Local returnLocal = null;
        if (method.getReturnType() != Void.TYPE) {
            returnLocal = codeEmitter.make_local();
            codeEmitter.store_local(returnLocal);
        }
        if (returnLocal != null) {
            codeEmitter.load_local(returnLocal);
            codeEmitter.unbox_or_zero(Type.getType(method.getReturnType()));
        }
        codeEmitter.return_value();
        codeEmitter.end_method();
        return true;
    }

    void generateProxyMethod(Method method, String targetInvField, GeneratorContext context, CodeEmitter codeEmitter) {
        AdvisedSupport config = context.getConfig();
        boolean exposeProxy = config.isExposeProxy();
        boolean isStatic = config.getTargetSource().isStatic();
        boolean opaque = config.isOpaque();
        if (opaque) {
            if (exposeProxy) {
                codeEmitter.load_this();
            }
            codeEmitter.load_this();
            if (isStatic) {
                codeEmitter.getfield("target");
                codeEmitter.getfield(targetInvField);
                this.prepareArgs(method, codeEmitter);
                if (exposeProxy) {
                    codeEmitter.invoke_static(stdProxyInvoker, staticExposeProceed);
                } else {
                    codeEmitter.invoke_static(stdProxyInvoker, proceed);
                }
            } else {
                codeEmitter.getfield("targetSource");
                codeEmitter.getfield(targetInvField);
                this.prepareArgs(method, codeEmitter);
                if (exposeProxy) {
                    codeEmitter.invoke_static(stdProxyInvoker, dynamicExposeProceed);
                } else {
                    codeEmitter.invoke_static(stdProxyInvoker, dynamicProceed);
                }
            }
        } else {
            codeEmitter.load_this();
            codeEmitter.load_this();
            codeEmitter.getfield("config");
            codeEmitter.getfield(targetInvField);
            this.prepareArgs(method, codeEmitter);
            codeEmitter.invoke_static(stdProxyInvoker, dynamicAdvisedProceed);
        }
    }

    protected String putTargetInv(Method method, GeneratorContext context, List<String> fields) {
        String field = method.getName() + StringUtils.getRandomString(4);
        if (fields.contains(field)) {
            return this.putTargetInv(method, context, fields);
        }
        TargetInvocation target = TargetInvocation.getTarget(field);
        if (target != null) {
            return this.putTargetInv(method, context, fields);
        }
        TargetInvocation.putTarget(field, this.getTarget(method, context));
        return field;
    }

    protected int getStaticAccess() {
        return 26;
    }

    protected TargetInvocation getTarget(Method method, GeneratorContext context) {
        return new TargetInvocation(method, context.getTargetClass(), context.getConfig());
    }

    protected void prepareArgs(Method method, CodeEmitter codeEmitter) {
        if (method.getParameterCount() == 0) {
            EmitUtils.loadEmptyArguments(codeEmitter);
        } else {
            codeEmitter.create_arg_array();
        }
    }

    static {
        stdProxyInvoker = Type.getType(StandardProxyInvoker.class);
        targetInvocationType = Type.getType(TargetInvocation.class);
        try {
            proceed = new Signature(StandardProxyInvoker.class.getMethod("proceed", Object.class, TargetInvocation.class, Object[].class));
            dynamicProceed = new Signature(StandardProxyInvoker.class.getMethod("dynamicProceed", TargetSource.class, TargetInvocation.class, Object[].class));
            dynamicExposeProceed = new Signature(StandardProxyInvoker.class.getMethod("dynamicExposeProceed", Object.class, TargetSource.class, TargetInvocation.class, Object[].class));
            staticExposeProceed = new Signature(StandardProxyInvoker.class.getMethod("staticExposeProceed", Object.class, Object.class, TargetInvocation.class, Object[].class));
            dynamicAdvisedProceed = new Signature(StandardProxyInvoker.class.getMethod("dynamicAdvisedProceed", Object.class, AdvisedSupport.class, TargetInvocation.class, Object[].class));
        }
        catch (NoSuchMethodException e) {
            throw new CodeGenerationException(e);
        }
    }
}

