/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.proxy;

import cn.taketoday.aop.AdvisedSupportListener;
import cn.taketoday.aop.proxy.AdvisedSupport;
import cn.taketoday.aop.proxy.AopProxy;
import cn.taketoday.aop.support.AopUtils;
import cn.taketoday.context.utils.Assert;
import java.util.ArrayList;

public class ProxyCreatorSupport
extends AdvisedSupport {
    private static final long serialVersionUID = 1L;
    private boolean active = false;
    private final ArrayList<AdvisedSupportListener> listeners = new ArrayList();

    protected final synchronized AopProxy createAopProxy() {
        if (!this.active) {
            this.activate();
        }
        return AopUtils.createAopProxy(this);
    }

    private void activate() {
        this.active = true;
        for (AdvisedSupportListener listener : this.listeners) {
            listener.activated(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void adviceChanged() {
        super.adviceChanged();
        ProxyCreatorSupport proxyCreatorSupport = this;
        synchronized (proxyCreatorSupport) {
            if (this.active) {
                for (AdvisedSupportListener listener : this.listeners) {
                    listener.adviceChanged(this);
                }
            }
        }
    }

    protected final synchronized boolean isActive() {
        return this.active;
    }

    public void addListener(AdvisedSupportListener listener) {
        Assert.notNull((Object)listener, "AdvisedSupportListener must not be null");
        this.listeners.add(listener);
    }

    public void removeListener(AdvisedSupportListener listener) {
        Assert.notNull((Object)listener, "AdvisedSupportListener must not be null");
        this.listeners.remove(listener);
    }
}

