/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.proxy;

import cn.taketoday.aop.TargetClassAware;
import cn.taketoday.aop.TargetSource;
import cn.taketoday.aop.proxy.Advised;
import cn.taketoday.aop.proxy.AdvisedSupport;
import cn.taketoday.aop.proxy.StandardProxy;
import cn.taketoday.aop.support.AopUtils;
import cn.taketoday.aop.target.SingletonTargetSource;
import cn.taketoday.context.DecoratingProxy;
import cn.taketoday.context.utils.Assert;
import java.lang.reflect.Proxy;
import java.util.Arrays;

public abstract class AopProxyUtils {
    public static Object getSingletonTarget(Object candidate) {
        TargetSource targetSource;
        if (candidate instanceof Advised && (targetSource = ((Advised)candidate).getTargetSource()) instanceof SingletonTargetSource) {
            return ((SingletonTargetSource)targetSource).getTarget();
        }
        return null;
    }

    public static Class<?> ultimateTargetClass(Object candidate) {
        Assert.notNull(candidate, "Candidate object must not be null");
        Object current = candidate;
        Class<?> result = null;
        while (current instanceof TargetClassAware) {
            result = ((TargetClassAware)current).getTargetClass();
            current = AopProxyUtils.getSingletonTarget(current);
        }
        if (result == null) {
            result = AopUtils.isCglibProxy(candidate) ? candidate.getClass().getSuperclass() : candidate.getClass();
        }
        return result;
    }

    public static Class<?>[] completeProxiedInterfaces(AdvisedSupport advised) {
        return AopProxyUtils.completeProxiedInterfaces(advised, false);
    }

    public static Class<?>[] completeProxiedInterfaces(AdvisedSupport advised, boolean decoratingProxy) {
        Class<?> targetClass;
        Class<?>[] specifiedInterfaces = advised.getProxiedInterfaces();
        if (specifiedInterfaces.length == 0 && (targetClass = advised.getTargetClass()) != null) {
            if (targetClass.isInterface()) {
                advised.setInterfaces(targetClass);
            } else if (Proxy.isProxyClass(targetClass)) {
                advised.setInterfaces(targetClass.getInterfaces());
            }
            specifiedInterfaces = advised.getProxiedInterfaces();
        }
        boolean addProxy = !advised.isInterfaceProxied(StandardProxy.class);
        boolean addAdvised = !advised.isOpaque() && !advised.isInterfaceProxied(Advised.class);
        boolean addDecoratingProxy = decoratingProxy && !advised.isInterfaceProxied(DecoratingProxy.class);
        int nonUserIfcCount = 0;
        if (addProxy) {
            ++nonUserIfcCount;
        }
        if (addAdvised) {
            ++nonUserIfcCount;
        }
        if (addDecoratingProxy) {
            ++nonUserIfcCount;
        }
        Class[] proxiedInterfaces = new Class[specifiedInterfaces.length + nonUserIfcCount];
        System.arraycopy(specifiedInterfaces, 0, proxiedInterfaces, 0, specifiedInterfaces.length);
        int index = specifiedInterfaces.length;
        if (addProxy) {
            proxiedInterfaces[index++] = StandardProxy.class;
        }
        if (addDecoratingProxy) {
            proxiedInterfaces[index++] = DecoratingProxy.class;
        }
        if (addAdvised) {
            proxiedInterfaces[index] = Advised.class;
        }
        return proxiedInterfaces;
    }

    public static Class<?>[] proxiedUserInterfaces(Object proxy) {
        Class<?>[] proxyInterfaces = proxy.getClass().getInterfaces();
        int nonUserIfcCount = 0;
        if (proxy instanceof StandardProxy) {
            ++nonUserIfcCount;
        }
        if (proxy instanceof Advised) {
            ++nonUserIfcCount;
        }
        if (proxy instanceof DecoratingProxy) {
            ++nonUserIfcCount;
        }
        Object[] userInterfaces = Arrays.copyOf(proxyInterfaces, proxyInterfaces.length - nonUserIfcCount);
        Assert.notEmpty(userInterfaces, "JDK proxy must implement one or more interfaces");
        return userInterfaces;
    }

    public static boolean equalsInProxy(AdvisedSupport a, AdvisedSupport b) {
        return a == b || AopProxyUtils.equalsProxiedInterfaces(a, b) && AopProxyUtils.equalsAdvisors(a, b) && a.getTargetSource().equals(b.getTargetSource());
    }

    public static boolean equalsProxiedInterfaces(AdvisedSupport a, AdvisedSupport b) {
        return Arrays.equals(a.getProxiedInterfaces(), b.getProxiedInterfaces());
    }

    public static boolean equalsAdvisors(AdvisedSupport a, AdvisedSupport b) {
        return a.getAdvisorCount() == b.getAdvisorCount() && Arrays.equals(a.getAdvisors(), b.getAdvisors());
    }
}

