/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.proxy;

import cn.taketoday.aop.Advisor;
import cn.taketoday.aop.AopInfrastructureBean;
import cn.taketoday.aop.Pointcut;
import cn.taketoday.aop.TargetSource;
import cn.taketoday.aop.proxy.ProxyConfig;
import cn.taketoday.aop.proxy.ProxyCreator;
import cn.taketoday.aop.proxy.ProxyFactory;
import cn.taketoday.aop.support.AopUtils;
import cn.taketoday.aop.target.SingletonTargetSource;
import cn.taketoday.aop.target.TargetSourceCreator;
import cn.taketoday.context.aware.Aware;
import cn.taketoday.context.aware.BeanFactoryAware;
import cn.taketoday.context.factory.BeanDefinition;
import cn.taketoday.context.factory.BeanFactory;
import cn.taketoday.context.factory.DisposableBean;
import cn.taketoday.context.factory.InitializingBean;
import cn.taketoday.context.factory.InstantiationAwareBeanPostProcessor;
import cn.taketoday.context.logger.Logger;
import cn.taketoday.context.logger.LoggerFactory;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ContextUtils;
import cn.taketoday.context.utils.ObjectUtils;
import cn.taketoday.context.utils.OrderUtils;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import org.aopalliance.aop.Advice;

public abstract class AbstractAutoProxyCreator
extends ProxyConfig
implements InstantiationAwareBeanPostProcessor,
BeanFactoryAware,
AopInfrastructureBean,
ProxyCreator {
    private static final long serialVersionUID = 1L;
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private BeanFactory beanFactory;
    private static final Object[] DO_NOT_PROXY = null;
    private boolean freezeProxy = false;
    private transient TargetSourceCreator[] targetSourceCreators;
    private transient ClassLoader proxyClassLoader = ClassUtils.getClassLoader();
    private List<Advisor> candidateAdvisors;

    public void setTargetSourceCreators(TargetSourceCreator ... targetSourceCreators) {
        this.targetSourceCreators = targetSourceCreators;
    }

    @Override
    public void setFrozen(boolean frozen) {
        this.freezeProxy = frozen;
    }

    @Override
    public boolean isFrozen() {
        return this.freezeProxy;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setProxyClassLoader(ClassLoader proxyClassLoader) {
        this.proxyClassLoader = proxyClassLoader;
    }

    private ClassLoader getProxyClassLoader() {
        return this.proxyClassLoader;
    }

    @Override
    public Object postProcessBeforeInstantiation(BeanDefinition def) {
        Object[] specificInterceptors;
        TargetSource targetSource = this.getCustomTargetSource(def);
        if (targetSource != null && ObjectUtils.isNotEmpty(specificInterceptors = this.getAdvicesAndAdvisorsForBean(def, targetSource))) {
            return this.createProxy(def, specificInterceptors, targetSource);
        }
        return null;
    }

    protected TargetSource getCustomTargetSource(BeanDefinition def) {
        if (this.targetSourceCreators != null) {
            for (TargetSourceCreator creator : this.targetSourceCreators) {
                TargetSource source = creator.getTargetSource(def);
                if (source == null) continue;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("TargetSourceCreator [{}] found custom TargetSource for bean with BeanDefinition '{}'", (Object)creator, (Object)def);
                }
                return source;
            }
        }
        return null;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, BeanDefinition def) {
        return this.wrapIfNecessary(bean, def);
    }

    protected boolean advisorsPreFiltered() {
        return false;
    }

    protected void customizeProxyFactory(ProxyFactory proxyFactory) {
    }

    protected Advisor[] getAdvisors(BeanDefinition def, Object[] specificInterceptors) {
        Advisor[] ret = new Advisor[specificInterceptors.length];
        int i = 0;
        for (Object specificInterceptor : specificInterceptors) {
            ret[i++] = AopUtils.wrap(specificInterceptor);
        }
        return ret;
    }

    protected Object wrapIfNecessary(Object bean, BeanDefinition def) {
        if (this.isInfrastructureClass(bean.getClass()) || this.shouldSkip(bean, def)) {
            return bean;
        }
        TargetSource targetSource = this.getTargetSource(bean, def);
        Object[] specificInterceptors = this.getAdvicesAndAdvisorsForBean(def, targetSource);
        if (ObjectUtils.isNotEmpty(specificInterceptors)) {
            return this.createProxy(def, specificInterceptors, targetSource);
        }
        return bean;
    }

    protected TargetSource getTargetSource(Object bean, BeanDefinition def) {
        TargetSource targetSource = this.getCustomTargetSource(def);
        if (targetSource == null) {
            targetSource = new SingletonTargetSource(bean);
        }
        return targetSource;
    }

    protected Object createProxy(BeanDefinition def, Object[] specificInterceptors, TargetSource targetSource) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.copyFrom(this);
        if (!proxyFactory.isProxyTargetClass()) {
            if (this.shouldProxyTargetClass(def)) {
                proxyFactory.setProxyTargetClass(true);
            } else {
                this.evaluateProxyInterfaces(def.getBeanClass(), proxyFactory);
            }
        }
        Advisor[] advisors = this.getAdvisors(def, specificInterceptors);
        proxyFactory.addAdvisors(advisors);
        proxyFactory.setTargetSource(targetSource);
        this.customizeProxyFactory(proxyFactory);
        proxyFactory.setFrozen(this.freezeProxy);
        if (this.advisorsPreFiltered()) {
            proxyFactory.setPreFiltered(true);
        }
        return proxyFactory.getProxy(this.getProxyClassLoader(), constructor -> ContextUtils.resolveParameter(constructor, this.beanFactory));
    }

    protected Object[] getAdvicesAndAdvisorsForBean(BeanDefinition def, TargetSource targetSource) {
        List<Advisor> candidateAdvisors = this.getCandidateAdvisors();
        List<Advisor> eligibleAdvisors = this.filterAdvisors(candidateAdvisors, def, targetSource);
        this.postEligibleAdvisors(eligibleAdvisors);
        eligibleAdvisors = this.sortAdvisors(eligibleAdvisors);
        if (eligibleAdvisors.isEmpty()) {
            return DO_NOT_PROXY;
        }
        return eligibleAdvisors.toArray();
    }

    protected List<Advisor> filterAdvisors(List<Advisor> candidateAdvisors, BeanDefinition def, TargetSource targetSource) {
        return AopUtils.filterAdvisors(candidateAdvisors, def.getBeanClass());
    }

    protected List<Advisor> getCandidateAdvisors() {
        if (this.candidateAdvisors == null) {
            this.candidateAdvisors = new ArrayList<Advisor>();
            this.addCandidateAdvisors(this.candidateAdvisors);
        }
        return this.candidateAdvisors;
    }

    protected void addCandidateAdvisors(List<Advisor> candidateAdvisors) {
        BeanFactory beanFactory = this.getBeanFactory();
        candidateAdvisors.addAll(beanFactory.getBeans(Advisor.class));
    }

    protected void postEligibleAdvisors(List<Advisor> eligibleAdvisors) {
    }

    protected List<Advisor> sortAdvisors(List<Advisor> advisors) {
        return OrderUtils.reversedSort(advisors);
    }

    protected boolean shouldSkip(Object bean, BeanDefinition def) {
        return false;
    }

    protected boolean isInfrastructureClass(Class<?> beanClass) {
        return Advice.class.isAssignableFrom(beanClass) || Advisor.class.isAssignableFrom(beanClass) || Pointcut.class.isAssignableFrom(beanClass) || AopInfrastructureBean.class.isAssignableFrom(beanClass);
    }

    protected void evaluateProxyInterfaces(Class<?> beanClass, ProxyFactory proxyFactory) {
        Class<?>[] targetInterfaces = ClassUtils.getAllInterfacesForClass(beanClass, this.getProxyClassLoader());
        boolean hasReasonableProxyInterface = false;
        for (Class<?> ifc : targetInterfaces) {
            if (this.isConfigurationCallbackInterface(ifc) || ifc.getMethods().length <= 0) continue;
            hasReasonableProxyInterface = true;
            break;
        }
        if (hasReasonableProxyInterface) {
            for (Class<?> ifc : targetInterfaces) {
                proxyFactory.addInterface(ifc);
            }
        } else {
            proxyFactory.setProxyTargetClass(true);
        }
    }

    protected boolean isConfigurationCallbackInterface(Class<?> ifc) {
        return InitializingBean.class == ifc || Closeable.class == ifc || AutoCloseable.class == ifc || DisposableBean.class == ifc || ObjectUtils.containsElement(ifc.getInterfaces(), Aware.class);
    }

    protected boolean shouldProxyTargetClass(BeanDefinition def) {
        return false;
    }
}

