/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://oss.oracle.com/licenses/CDDL+GPL-1.1
 * or LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

/* Generated By:JavaCC: Do not edit this line. JJTELParserState.java Version 5.0 */
package cn.taketoday.expression.parser;

import java.util.ArrayList;

public class ExpressionParserState {

  private final ArrayList<Node> nodes = new ArrayList<>();
  private final ArrayList<Integer> marks = new ArrayList<>();

  private int sp = 0; // number of nodes on stack
  private int mk = 0; // current mark
  private boolean nodeCreated;

  /**
   * Determines whether the current node was actually closed and pushed. This
   * should only be called in the final user action of a node scope.
   */
  public boolean nodeCreated() {
    return nodeCreated;
  }

  /**
   * Call this to reinitialize the node stack. It is called automatically by the
   * parser's ReInit() method.
   */
  public void reset() {
    nodes.clear();
    marks.clear();
    sp = 0;
    mk = 0;
  }

  /**
   * Returns the root node of the AST. It only makes sense to call this after a
   * successful parse.
   */
  public Node rootNode() {
    return nodes.get(0);
  }

  /** Pushes a node on to the stack. */
  public void pushNode(Node n) {
    nodes.add(n);
    ++sp;
  }

  /**
   * Returns the node on the top of the stack, and remove it from the stack.
   */
  public Node popNode() {
    if (--sp < mk) {
      mk = marks.remove(marks.size() - 1);
    }
    return nodes.remove(nodes.size() - 1);
  }

  /** Returns the node currently on the top of the stack. */
  public Node peekNode() {
    return nodes.get(nodes.size() - 1);
  }

  /**
   * Returns the number of children on the stack in the current node scope.
   */
  public int nodeArity() {
    return sp - mk;
  }

  public void clearNodeScope(Node n) {
    while (sp > mk) {
      popNode();
    }
    mk = marks.remove(marks.size() - 1);
  }

  public void openNodeScope(Node n) {
    marks.add(mk);
    mk = sp;
    n.jjtOpen();
  }

  /**
   * A definite node is constructed from a specified number of children. That
   * number of nodes are popped from the stack and made the children of the
   * definite node. Then the definite node is pushed on to the stack.
   */
  public void closeNodeScope(Node n, int num) {
    mk = marks.remove(marks.size() - 1);
    while (num-- > 0) {
      Node c = popNode();
      c.jjtSetParent(n);
      n.jjtAddChild(c, num);
    }
    n.jjtClose();
    pushNode(n);
    nodeCreated = true;
  }

  /**
   * A conditional node is constructed if its condition is true. All the nodes
   * that have been pushed since the node was opened are made children of the
   * conditional node, which is then pushed on to the stack. If the condition is
   * false the node is not constructed and they are left on the stack.
   */
  public void closeNodeScope(Node n, boolean condition) {
    if (condition) {
      int a = nodeArity();
      closeNodeScope(n, a);
    }
    else {
      mk = marks.remove(marks.size() - 1);
      nodeCreated = false;
    }
  }
}
