/*
 * Copyright 2003 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.taketoday.context.cglib.transform.impl;

import cn.taketoday.context.Constant;
import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.CodeEmitter;
import cn.taketoday.context.cglib.core.Signature;
import cn.taketoday.context.cglib.core.TypeUtils;
import cn.taketoday.context.cglib.transform.ClassEmitterTransformer;

/**
 * @author TODAY <br>
 * 2019-09-04 19:57
 */
public class AccessFieldTransformer extends ClassEmitterTransformer {

  private final Callback callback;

  public AccessFieldTransformer(Callback callback) {
    this.callback = callback;
  }

  public interface Callback {
    String getPropertyName(Type owner, String fieldName);
  }

  public void declare_field(int access, final String name, Type type, Object value) {
    super.declare_field(access, name, type, value);

    String property = TypeUtils.upperFirst(callback.getPropertyName(getClassType(), name));
    if (property != null) {
      CodeEmitter e;
      e = beginMethod(Constant.ACC_PUBLIC, new Signature("get" + property, type, Constant.TYPES_EMPTY_ARRAY));
      e.load_this();
      e.getfield(name);
      e.return_value();
      e.end_method();

      e = beginMethod(Constant.ACC_PUBLIC, new Signature("set" + property, Type.VOID_TYPE, Type.array(type)));
      e.load_this();
      e.load_arg(0);
      e.putfield(name);
      e.return_value();
      e.end_method();
    }
  }
}
