/*
 * Original Author -> 杨海健 (taketoday@foxmail.com) https://taketoday.cn
 * Copyright © TODAY & 2017 - 2021 All Rights Reserved.
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see [http://www.gnu.org/licenses/]
 */

package cn.taketoday.aop;

/**
 * Filter that restricts matching of a pointcut or introduction to
 * a given set of target classes.
 *
 * <p>Can be used as part of a {@link Pointcut} or for the entire
 * targeting of an {@link IntroductionAdvisor}.
 *
 * <p>Concrete implementations of this interface typically should provide proper
 * implementations of {@link Object#equals(Object)} and {@link Object#hashCode()}
 * in order to allow the filter to be used in caching scenarios &mdash; for
 * example, in proxies generated by CGLIB.
 *
 * @author Rod Johnson
 * @author TODAY 2021/2/1 18:12
 * @see Pointcut
 * @see MethodMatcher
 * @since 3.0
 */
@FunctionalInterface
public interface ClassFilter {

  /**
   * Should the pointcut apply to the given interface or target class?
   *
   * @param clazz
   *         the candidate target class
   *
   * @return whether the advice should apply to the given target class
   */
  boolean matches(Class<?> clazz);

  /**
   * Canonical instance of a ClassFilter that matches all classes.
   */
  ClassFilter TRUE = TrueClassFilter.INSTANCE;

}
