/*
 * Original Author -> 杨海健 (taketoday@foxmail.com) https://taketoday.cn
 * Copyright © TODAY & 2017 - 2021 All Rights Reserved.
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see [http://www.gnu.org/licenses/]
 */

package cn.taketoday.context.reflect;

/**
 * @author TODAY 2021/2/12 12:23
 * @since 3.0
 */
public abstract class SetterSupport implements SetterMethod {
  private boolean primitive;

  protected SetterSupport() { }

  protected SetterSupport(boolean primitive) {
    this.primitive = primitive;
  }

  /**
   * If property is a primitive type and value is {@code null},
   * do nothing
   *
   * @param obj
   *         object
   * @param value
   *         value
   */
  @Override
  public final void set(Object obj, Object value) {
    if (!primitive || value != null) {
      setInternal(obj, value);
    }
  }

  protected abstract void setInternal(Object obj, Object value);

  public void setPrimitive(boolean primitive) {
    this.primitive = primitive;
  }

  public boolean isPrimitive() {
    return primitive;
  }
}
