/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.utils;

import cn.taketoday.context.Constant;
import java.io.CharArrayWriter;
import java.util.BitSet;
import java.util.Collection;

public abstract class StringUtils {
    private static final int caseDiff = 32;
    private static BitSet dontNeedEncoding;

    public static final boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static final boolean isNotEmpty(String str) {
        return str != null && str.length() != 0;
    }

    public static final boolean isArrayNotEmpty(String ... strs) {
        return strs != null && strs.length != 0;
    }

    public static final boolean isArrayEmpty(String ... strs) {
        return strs == null || strs.length == 0;
    }

    public static String[] split(String source) {
        if (source == null) {
            return null;
        }
        return source.split("[;|,]");
    }

    public static String decodeUrl(String s) {
        boolean needToChange = false;
        int numChars = s.length();
        StringBuffer sb = new StringBuffer(numChars > 500 ? numChars / 2 : numChars);
        int i = 0;
        byte[] bytes = null;
        block6: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    ++i;
                    needToChange = true;
                    continue block6;
                }
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i) / 3];
                        }
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            int v = Integer.parseInt(s.substring(i + 1, i + 3), 16);
                            if (v < 0) {
                                throw new IllegalArgumentException("Illegal hex characters in escape (%) pattern - negative value");
                            }
                            bytes[pos++] = (byte)v;
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            throw new IllegalArgumentException("Incomplete trailing escape (%) pattern");
                        }
                        sb.append(new String(bytes, 0, pos, Constant.DEFAULT_CHARSET));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Illegal hex characters in escape (%) pattern - " + e.getMessage());
                    }
                    needToChange = true;
                    continue block6;
                }
            }
            sb.append(c);
            ++i;
        }
        return needToChange ? sb.toString() : s;
    }

    public static String encodeUrl(String s) {
        boolean needToChange = false;
        int length = s.length();
        StringBuffer out = new StringBuffer(length);
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        int i = 0;
        while (i < length) {
            char c;
            int c2 = s.charAt(i);
            if (dontNeedEncoding.get(c2)) {
                if (c2 == 32) {
                    c2 = 43;
                    needToChange = true;
                }
                out.append((char)c2);
                ++i;
                continue;
            }
            do {
                char d;
                charArrayWriter.write(c2);
                if (c2 >= 55296 && c2 <= 56319 && i + 1 < length && (d = s.charAt(i + 1)) >= '\udc00' && d <= '\udfff') {
                    charArrayWriter.write(d);
                    ++i;
                }
                if (++i >= length) break;
                c = s.charAt(i);
                c2 = c;
            } while (!dontNeedEncoding.get(c));
            charArrayWriter.flush();
            String str = new String(charArrayWriter.toCharArray());
            byte[] ba = str.getBytes(Constant.DEFAULT_CHARSET);
            for (int j = 0; j < ba.length; ++j) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            charArrayWriter.reset();
            needToChange = true;
        }
        return needToChange ? out.toString() : s;
    }

    public static String[] toStringArray(Collection<String> collection) {
        return collection.toArray(new String[0]);
    }

    public static String arrayToString(String[] array) {
        return StringUtils.arrayToString(array, ",");
    }

    public static String arrayToString(String[] array, String suffix) {
        if (array == null) {
            return "null";
        }
        int length = array.length;
        if (length == 1) {
            return array[0];
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(array[i]);
            if (i == length - 1) continue;
            builder.append(suffix);
        }
        return builder.toString();
    }

    static {
        int i;
        dontNeedEncoding = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            dontNeedEncoding.set(i);
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
    }
}

