/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.utils;

import cn.taketoday.context.Ordered;
import cn.taketoday.context.annotation.Order;
import java.lang.reflect.AnnotatedElement;
import java.util.Comparator;
import java.util.List;

public abstract class OrderUtils {
    public static final int getOrder(AnnotatedElement annotated) {
        Order order = annotated.getAnnotation(Order.class);
        if (order != null) {
            return order.value();
        }
        return 0;
    }

    public static final int getOrder(Object obj) {
        if (obj instanceof Ordered) {
            return ((Ordered)obj).getOrder();
        }
        if (obj instanceof AnnotatedElement) {
            return OrderUtils.getOrder((AnnotatedElement)obj);
        }
        return OrderUtils.getOrder(obj.getClass());
    }

    public static Comparator<Object> getReversedComparator() {
        return Comparator.comparingInt(OrderUtils::getOrder).reversed();
    }

    public static <T> void reversedSort(List<T> list) {
        list.sort(OrderUtils.getReversedComparator());
    }
}

