/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.utils;

import cn.taketoday.context.exception.ConversionException;
import cn.taketoday.context.utils.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class NumberUtils {
    public static final Object toArrayObject(String[] source, Class<?> targetClass) throws ConversionException {
        int length = source.length;
        if (int[].class == targetClass) {
            int[] newInstance = new int[length];
            for (int j = 0; j < length; j = (int)((short)(j + 1))) {
                newInstance[j] = Integer.parseInt(source[j]);
            }
            return newInstance;
        }
        if (Integer[].class == targetClass) {
            Integer[] newInstance = new Integer[length];
            for (int j = 0; j < length; j = (int)((short)(j + 1))) {
                newInstance[j] = Integer.parseInt(source[j]);
            }
            return newInstance;
        }
        if (long[].class == targetClass) {
            long[] newInstance = new long[length];
            for (int j = 0; j < length; j = (int)((short)(j + 1))) {
                newInstance[j] = Long.parseLong(source[j]);
            }
            return newInstance;
        }
        if (Long[].class == targetClass) {
            Long[] newInstance = new Long[length];
            for (int j = 0; j < length; j = (int)((short)(j + 1))) {
                newInstance[j] = Long.parseLong(source[j]);
            }
            return newInstance;
        }
        if (short[].class == targetClass) {
            short[] newInstance = new short[length];
            for (int j = 0; j < length; j = (int)((short)(j + 1))) {
                newInstance[j] = Short.parseShort(source[j]);
            }
            return newInstance;
        }
        if (Short[].class == targetClass) {
            Short[] newInstance = new Short[length];
            for (int j = 0; j < length; j = (int)((short)(j + 1))) {
                newInstance[j] = Short.parseShort(source[j]);
            }
            return newInstance;
        }
        if (byte[].class == targetClass) {
            byte[] newInstance = new byte[length];
            for (int j = 0; j < length; j = (int)((short)(j + 1))) {
                newInstance[j] = Byte.parseByte(source[j]);
            }
            return newInstance;
        }
        if (Byte[].class == targetClass) {
            Byte[] newInstance = new Byte[length];
            for (int j = 0; j < length; j = (int)((short)(j + 1))) {
                newInstance[j] = Byte.parseByte(source[j]);
            }
            return newInstance;
        }
        if (float[].class == targetClass) {
            float[] newInstance = new float[length];
            for (int j = 0; j < length; j = (int)((short)(j + 1))) {
                newInstance[j] = Float.parseFloat(source[j]);
            }
            return newInstance;
        }
        if (Float[].class == targetClass) {
            Float[] newInstance = new Float[length];
            for (int j = 0; j < length; j = (int)((short)(j + 1))) {
                newInstance[j] = Float.valueOf(Float.parseFloat(source[j]));
            }
            return newInstance;
        }
        if (double[].class == targetClass) {
            double[] newInstance = new double[length];
            for (int j = 0; j < length; j = (int)((short)(j + 1))) {
                newInstance[j] = Double.parseDouble(source[j]);
            }
            return newInstance;
        }
        if (Double[].class == targetClass) {
            Double[] newInstance = new Double[length];
            for (int j = 0; j < length; j = (int)((short)(j + 1))) {
                newInstance[j] = Double.parseDouble(source[j]);
            }
            return newInstance;
        }
        return null;
    }

    public static final <T> T parseArray(String[] source, Class<T> targetClass) throws ConversionException {
        return targetClass.cast(NumberUtils.toArrayObject(source, targetClass));
    }

    public static final <T extends Number> T parseNumber(String text, Class<T> targetClass) throws ConversionException {
        return (T)((Number)targetClass.cast(NumberUtils.parseDigit(text, targetClass)));
    }

    public static final Object parseDigit(String text, Class<?> targetClass) throws ConversionException {
        if (StringUtils.isEmpty(text)) {
            return 0;
        }
        if (Byte.class == targetClass || Byte.TYPE == targetClass) {
            return Byte.parseByte(text);
        }
        if (Short.class == targetClass || Short.TYPE == targetClass) {
            return Short.parseShort(text);
        }
        if (Integer.class == targetClass || Integer.TYPE == targetClass) {
            return Integer.parseInt(text);
        }
        if (Long.class == targetClass || Long.TYPE == targetClass) {
            return Long.parseLong(text);
        }
        if (BigInteger.class == targetClass) {
            return new BigInteger(text);
        }
        if (Float.class == targetClass || Float.TYPE == targetClass) {
            return Float.valueOf(Float.parseFloat(text));
        }
        if (Double.class == targetClass || Double.TYPE == targetClass) {
            return Double.parseDouble(text);
        }
        if (BigDecimal.class == targetClass || Number.class == targetClass) {
            return new BigDecimal(text);
        }
        throw new ConversionException("can't convert[" + text + "] to [" + targetClass.getName() + "]");
    }

    public static final boolean isNumber(Class<?> targetClass) {
        return Number.class.isAssignableFrom(targetClass) || targetClass == Integer.TYPE || targetClass == Long.TYPE || targetClass == Float.TYPE || targetClass == Double.TYPE || targetClass == Short.TYPE || targetClass == Byte.TYPE;
    }
}

