/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.utils;

import cn.taketoday.context.exception.ContextException;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.DataSize;
import cn.taketoday.context.utils.StringUtils;
import java.io.File;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.Duration;

public abstract class ConvertUtils {
    public static Object convert(String value, Class<?> targetClass) {
        if (StringUtils.isEmpty(value)) {
            return value;
        }
        switch (targetClass.getSimpleName()) {
            case "Byte": 
            case "byte": {
                return Byte.parseByte(value);
            }
            case "short": 
            case "Short": {
                return Short.parseShort(value);
            }
            case "int": 
            case "Integer": {
                return Integer.parseInt(value);
            }
            case "long": 
            case "Long": {
                return Long.parseLong(value);
            }
            case "float": 
            case "Float": {
                return Float.valueOf(Float.parseFloat(value));
            }
            case "double": 
            case "Double": {
                return Double.parseDouble(value);
            }
            case "boolean": 
            case "Boolean": {
                return Boolean.parseBoolean(value);
            }
            case "BigInteger": {
                return new BigInteger(value);
            }
            case "BigDecimal": {
                return new BigDecimal(value);
            }
            case "File": {
                if (value.startsWith("classpath:")) {
                    String resourceString = value.substring("classpath:".length());
                    URL resource = ClassUtils.getClassLoader().getResource(resourceString);
                    if (resource == null) {
                        throw new ContextException("ClassPath Recource: [" + resourceString + "] Doesn't exist");
                    }
                    return new File(resource.getPath());
                }
                return new File(value);
            }
            case "Charset": {
                return Charset.forName(value);
            }
            case "Class": {
                try {
                    return Class.forName(value);
                }
                catch (ClassNotFoundException e) {
                    throw new ContextException(e);
                }
            }
            case "Duration": {
                return ConvertUtils.convertDuration(value);
            }
            case "DataSize": {
                return DataSize.parse(value);
            }
        }
        if (targetClass.isEnum()) {
            return Enum.valueOf(targetClass, value);
        }
        if (targetClass.isArray()) {
            Class<?> componentType = targetClass.getComponentType();
            String[] split = StringUtils.split(value);
            Object arrayValue = Array.newInstance(componentType, split.length);
            for (int i = 0; i < split.length; ++i) {
                Array.set(arrayValue, i, ConvertUtils.convert(split[i], componentType));
            }
            return arrayValue;
        }
        try {
            return targetClass.getConstructor(String.class).newInstance(value);
        }
        catch (Throwable throwable) {
            return value;
        }
    }

    public static Duration convertDuration(String value) {
        if (value.endsWith("s")) {
            return Duration.ofSeconds(Long.parseLong(value.substring(0, value.length() - 1)));
        }
        if (value.endsWith("h")) {
            return Duration.ofHours(Long.parseLong(value.substring(0, value.length() - 1)));
        }
        if (value.endsWith("ns")) {
            return Duration.ofNanos(Long.parseLong(value.substring(0, value.length() - 2)));
        }
        if (value.endsWith("ms")) {
            return Duration.ofMillis(Long.parseLong(value.substring(0, value.length() - 2)));
        }
        if (value.endsWith("min")) {
            return Duration.ofMinutes(Long.parseLong(value.substring(0, value.length() - 3)));
        }
        if (value.endsWith("d")) {
            return Duration.ofDays(Long.parseLong(value.substring(0, value.length() - 1)));
        }
        return Duration.parse(value);
    }
}

