/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.utils;

import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.Condition;
import cn.taketoday.context.ConfigurableApplicationContext;
import cn.taketoday.context.Scope;
import cn.taketoday.context.annotation.Autowired;
import cn.taketoday.context.annotation.Conditional;
import cn.taketoday.context.annotation.ConditionalImpl;
import cn.taketoday.context.annotation.Props;
import cn.taketoday.context.annotation.Value;
import cn.taketoday.context.bean.BeanDefinition;
import cn.taketoday.context.bean.PropertyValue;
import cn.taketoday.context.bean.StandardBeanDefinition;
import cn.taketoday.context.env.Environment;
import cn.taketoday.context.exception.AnnotationException;
import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.exception.NoSuchBeanDefinitionException;
import cn.taketoday.context.factory.BeanFactory;
import cn.taketoday.context.loader.AutowiredPropertyResolver;
import cn.taketoday.context.loader.PropertyValueResolver;
import cn.taketoday.context.loader.PropsPropertyResolver;
import cn.taketoday.context.loader.ValuePropertyResolver;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ConvertUtils;
import cn.taketoday.context.utils.OrderUtils;
import cn.taketoday.context.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContextUtils {
    private static final Logger log = LoggerFactory.getLogger(ContextUtils.class);
    private static final Map<Class<? extends Annotation>, PropertyValueResolver> PROPERTY_VALUE_RESOLVERS = new HashMap<Class<? extends Annotation>, PropertyValueResolver>(4, 1.0f){
        {
            AutowiredPropertyResolver autowired = new AutowiredPropertyResolver();
            this.put(Resource.class, autowired);
            this.put(Autowired.class, autowired);
            this.put(Value.class, new ValuePropertyResolver());
            this.put(Props.class, new PropsPropertyResolver());
        }
    };

    public static String[] findNames(String defaultName, String ... names) {
        if (StringUtils.isArrayEmpty(names)) {
            return new String[]{defaultName};
        }
        return names;
    }

    public static Object[] resolveParameter(Method method, BeanFactory beanFactory) {
        int parameterLength = method.getParameterCount();
        if (parameterLength == 0) {
            return null;
        }
        Object[] args = new Object[parameterLength];
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameterLength; ++i) {
            String name;
            Parameter parameter = parameters[i];
            Autowired autowiredOnParamter = parameter.getAnnotation(Autowired.class);
            if (autowiredOnParamter != null && StringUtils.isNotEmpty(name = autowiredOnParamter.value())) {
                Object bean = beanFactory.getBean(name, parameter.getType());
                if (bean == null && autowiredOnParamter.required()) {
                    LoggerFactory.getLogger(ContextUtils.class).error("[{}] is required.", (Object)parameter);
                    throw new NoSuchBeanDefinitionException(name);
                }
                args[i] = bean;
                continue;
            }
            args[i] = beanFactory.getBean(parameter.getType());
        }
        return args;
    }

    public static final InputStream getResourceAsStream(String resource) throws IOException {
        InputStream in = ClassUtils.getClassLoader().getResourceAsStream(resource);
        if (in == null) {
            throw new IOException("Could not find resource " + resource);
        }
        return in;
    }

    public static final Properties getResourceAsProperties(String resource) throws IOException {
        Properties props = new Properties();
        try (InputStream in = ClassUtils.getClassLoader().getResourceAsStream(resource);){
            props.load(in);
        }
        return props;
    }

    public static final InputStream getUrlAsStream(String urlString) throws IOException {
        return new URL(urlString).openConnection().getInputStream();
    }

    public static final Properties getUrlAsProperties(String urlString) throws IOException {
        Properties props = new Properties();
        try (InputStream in = ContextUtils.getUrlAsStream(urlString);){
            props.load(in);
        }
        return props;
    }

    public static String resolvePlaceholder(Map<Object, Object> properties, String value) throws ConfigurationException {
        return ContextUtils.resolvePlaceholder(properties, value, true);
    }

    public static String resolvePlaceholder(Map<Object, Object> properties, String input, boolean throw_) throws ConfigurationException {
        if (input == null || input.length() <= 3) {
            return input;
        }
        int indexPrefix = 0;
        int indexSuffix = 0;
        StringBuilder builder = new StringBuilder();
        while ((indexPrefix = input.indexOf("#{")) > -1 && (indexSuffix = input.indexOf("}")) > -1) {
            builder.append(input.substring(0, indexPrefix));
            String key = input.substring(indexPrefix + 2, indexSuffix);
            Object property = properties.get(key);
            if (property == null) {
                if (throw_) {
                    throw new ConfigurationException("Properties -> [{}] , must specify a value.", key);
                }
                LoggerFactory.getLogger(ContextUtils.class).info("There is no property for key: [{}]", (Object)key);
                return null;
            }
            builder.append(ContextUtils.resolvePlaceholder(properties, property instanceof String ? (String)property : null, throw_));
            input = input.substring(indexSuffix + 1);
        }
        return builder.append(input).toString();
    }

    public static void resolveInitMethod(BeanDefinition beanDefinition, String ... initMethods) {
        beanDefinition.setInitMethods(ContextUtils.resolveInitMethod(beanDefinition.getBeanClass(), initMethods));
    }

    public static Method[] resolveInitMethod(Class<?> beanClass, String ... initMethods) {
        if (initMethods == null) {
            initMethods = new String[]{};
        }
        ArrayList<Method> methods = new ArrayList<Method>(4);
        ContextUtils.addInitMethod(methods, beanClass, initMethods);
        Class<?> superClass = beanClass.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            ContextUtils.addInitMethod(methods, superClass, initMethods);
        }
        OrderUtils.reversedSort(methods);
        return methods.toArray(new Method[0]);
    }

    static void addInitMethod(List<Method> methods, Class<?> beanClass, String ... initMethods) {
        for (Method method : beanClass.getDeclaredMethods()) {
            if (method.isAnnotationPresent(PostConstruct.class)) {
                methods.add(method);
                continue;
            }
            for (String initMethod : initMethods) {
                if (method.getParameterCount() != 0 || !initMethod.equals(method.getName())) continue;
                methods.add(method);
            }
        }
    }

    public static void resolvePropertyValue(BeanDefinition beanDefinition, ApplicationContext applicationContext) {
        beanDefinition.setPropertyValues(ContextUtils.resolvePropertyValue(beanDefinition.getBeanClass(), applicationContext));
    }

    public static PropertyValue[] resolvePropertyValue(Class<?> beanClass, ApplicationContext applicationContext) {
        HashSet<PropertyValue> propertyValues = new HashSet<PropertyValue>(32, 1.0f);
        for (Field field : ClassUtils.getFields(beanClass)) {
            PropertyValue created;
            if (!ContextUtils.supportsProperty(field) || (created = ContextUtils.createPropertyValue(field, applicationContext)) == null) continue;
            field.setAccessible(true);
            propertyValues.add(created);
        }
        return propertyValues.toArray(new PropertyValue[0]);
    }

    static PropertyValue createPropertyValue(Field field, ApplicationContext applicationContext) {
        for (Annotation annotation : field.getAnnotations()) {
            PropertyValueResolver propertyValueResolver = PROPERTY_VALUE_RESOLVERS.get(annotation.annotationType());
            if (propertyValueResolver == null) continue;
            return propertyValueResolver.resolveProperty(applicationContext, field);
        }
        throw new AnnotationException("Without regulation annotation present.");
    }

    static boolean supportsProperty(Field field) {
        for (Annotation annotation : field.getAnnotations()) {
            if (!PROPERTY_VALUE_RESOLVERS.containsKey(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    public static void resolveProps(BeanDefinition beanDefinition, Environment environment) throws ConfigurationException {
        Class<?> beanClass = beanDefinition.getBeanClass();
        if (beanClass.isAnnotationPresent(Props.class)) {
            beanDefinition.addPropertyValue(ContextUtils.resolveProps(beanClass, environment.getProperties()));
        }
    }

    public static List<PropertyValue> resolveProps(AnnotatedElement annotatedElement, Properties properties) throws ConfigurationException {
        Props props = annotatedElement.getAnnotation(Props.class);
        if (props == null) {
            return new ArrayList<PropertyValue>();
        }
        Class<?> annotatedClass = null;
        if (annotatedElement instanceof Class) {
            annotatedClass = (Class<?>)annotatedElement;
        } else if (annotatedElement instanceof Method) {
            annotatedClass = ((Method)annotatedElement).getReturnType();
        } else {
            throw new ConfigurationException("Not support annotated element: [{}]", annotatedElement);
        }
        log.debug("Loading Properties For: [{}]", (Object)annotatedClass.getName());
        ArrayList<PropertyValue> propertyValues = new ArrayList<PropertyValue>();
        String[] prefixs = props.prefix();
        for (Field declaredField : ClassUtils.getFields(annotatedClass)) {
            for (String prefix : prefixs) {
                String key = prefix + declaredField.getName();
                String value = properties.getProperty(key);
                if (value == null) continue;
                log.debug("Found Properties key: [{}]", (Object)key);
                declaredField.setAccessible(true);
                Object converted = ConvertUtils.convert(ContextUtils.resolvePlaceholder(properties, value), declaredField.getType());
                propertyValues.add(new PropertyValue(converted, declaredField));
            }
        }
        return propertyValues;
    }

    public static boolean conditional(AnnotatedElement annotatedElement, ConfigurableApplicationContext applicationContext) {
        Collection<ConditionalImpl> conditionals = ClassUtils.getAnnotation(annotatedElement, Conditional.class, ConditionalImpl.class);
        if (conditionals.isEmpty()) {
            return true;
        }
        for (Conditional conditional : conditionals) {
            for (Class<? extends Condition> conditionClass : conditional.value()) {
                Condition condition = ClassUtils.newInstance(conditionClass);
                if (condition.matches(applicationContext, annotatedElement)) continue;
                return false;
            }
        }
        return true;
    }

    public static void validateBeanDefinition(BeanDefinition beanDefinition, ApplicationContext applicationContext) {
        if (beanDefinition instanceof StandardBeanDefinition) {
            StandardBeanDefinition standardBeanDefinition = (StandardBeanDefinition)beanDefinition;
            if (StringUtils.isEmpty(standardBeanDefinition.getDeclaringName())) {
                throw new ConfigurationException("Declaring name can't be null", beanDefinition);
            }
            if (standardBeanDefinition.getFactoryMethod() == null) {
                throw new ConfigurationException("Factory Method can't be null", beanDefinition);
            }
        }
        if (beanDefinition.getBeanClass() == null) {
            throw new ConfigurationException("Definition's bean class can't be null", beanDefinition);
        }
        if (beanDefinition.getDestroyMethods() == null) {
            beanDefinition.setDestroyMethods(new String[0]);
        }
        if (beanDefinition.getInitMethods() == null) {
            beanDefinition.setInitMethods(ContextUtils.resolveInitMethod(beanDefinition.getBeanClass(), new String[0]));
        }
        if (beanDefinition.getPropertyValues() == null) {
            beanDefinition.setPropertyValues(ContextUtils.resolvePropertyValue(beanDefinition.getBeanClass(), applicationContext));
        }
        if (beanDefinition.getScope() == null) {
            beanDefinition.setScope(Scope.SINGLETON);
        }
    }
}

