/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.utils;

import cn.taketoday.context.AnnotationAttributes;
import cn.taketoday.context.asm.ClassReader;
import cn.taketoday.context.asm.ClassVisitor;
import cn.taketoday.context.asm.Label;
import cn.taketoday.context.asm.MethodVisitor;
import cn.taketoday.context.asm.Type;
import cn.taketoday.context.exception.ContextException;
import cn.taketoday.context.utils.ExceptionUtils;
import cn.taketoday.context.utils.StringUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClassUtils {
    private static final Logger log = LoggerFactory.getLogger(ClassUtils.class);
    private static Collection<Class<?>> classesCache;
    private static ClassLoader classLoader;
    private static final Set<Class<? extends Annotation>> IGNORE_ANNOTATION_CLASS;
    private static final FileFilter CLASS_FILE_FILTER;

    public static void addIgnoreAnnotationClass(Class<? extends Annotation> annotationClass) {
        IGNORE_ANNOTATION_CLASS.add(annotationClass);
    }

    public static final boolean isCollection(Class<?> cls) {
        return Collection.class.isAssignableFrom(cls);
    }

    public static boolean isPresent(String className) {
        Objects.requireNonNull(className, "class name can't be null");
        try {
            ClassUtils.forName(className);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static Class<?> forName(String name) throws ClassNotFoundException {
        return classLoader.loadClass(name);
    }

    public static Collection<Class<?>> getAnnotatedClasses(Class<? extends Annotation> annotationClass) {
        return ClassUtils.filter(clazz -> clazz.isAnnotationPresent(annotationClass));
    }

    public static Collection<Class<?>> getImplClasses(Class<?> superClass) {
        return ClassUtils.filter(clazz -> superClass.isAssignableFrom((Class<?>)clazz) && superClass != clazz);
    }

    public static Collection<Class<?>> getImplClasses(Class<?> superClass, String packageName) {
        return ClassUtils.filter(clazz -> clazz.getName().startsWith(packageName) && superClass.isAssignableFrom((Class<?>)clazz));
    }

    public static final <T> Collection<Class<?>> filter(Predicate<Class<?>> predicate) {
        return ClassUtils.getClassCache().parallelStream().filter(predicate).collect(Collectors.toSet());
    }

    public static Collection<Class<?>> getClasses(String ... packages) {
        if (StringUtils.isArrayEmpty(packages) || packages.length == 1 && StringUtils.isEmpty(packages[0])) {
            return ClassUtils.getClassCache();
        }
        return ClassUtils.filter(clazz -> {
            String name = clazz.getName();
            for (String prefix : packages) {
                if (!StringUtils.isEmpty(prefix) && !name.startsWith(prefix) && !name.startsWith("cn.taketoday")) continue;
                return true;
            }
            return false;
        });
    }

    public static Collection<Class<?>> scan(String ... packages) {
        Objects.requireNonNull(packages, "scan package can't be null");
        if (classesCache == null || classesCache.isEmpty()) {
            HashSet scanClasses = new HashSet(2048, 1.0f);
            for (String package_ : packages) {
                ClassUtils.scan(scanClasses, package_);
            }
            if (packages == null || packages.length != 1 || StringUtils.isNotEmpty(packages[0])) {
                ClassUtils.scan(scanClasses, "cn.taketoday");
            }
            ClassUtils.setClassCache(scanClasses);
            return scanClasses;
        }
        return ClassUtils.getClasses(packages);
    }

    public static void scan(Collection<Class<?>> scanClasses, String packageName) {
        packageName = StringUtils.isEmpty(packageName) ? "" : packageName.replace('.', '/');
        try {
            Enumeration<URL> uri = classLoader.getResources(packageName);
            while (uri.hasMoreElements()) {
                URL url = uri.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    ClassUtils.findAllClassWithPackage(packageName, StringUtils.decodeUrl(url.getFile()), scanClasses);
                    continue;
                }
                if ("jar".equals(protocol)) {
                    JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                    if (jarURLConnection == null) {
                        log.warn("Can't get the connection of the url: [{}]", (Object)url);
                        continue;
                    }
                    JarFile jarFile = jarURLConnection.getJarFile();
                    if (jarFile == null) continue;
                    Enumeration<JarEntry> jarEntries = jarFile.entries();
                    while (jarEntries.hasMoreElements()) {
                        ClassUtils.loadClassInJar(jarEntries.nextElement(), packageName, scanClasses);
                    }
                    continue;
                }
                log.warn("This Protocol: [{}] is not supported.", (Object)protocol);
            }
        }
        catch (IOException e) {
            log.error("IO exception occur With Msg: [{}]", (Object)e.getMessage(), (Object)e);
            throw new ContextException(e);
        }
    }

    public static void loadClassInJar(JarEntry jarEntry, String packageName, Collection<Class<?>> scanClasses) {
        String jarEntryName = jarEntry.getName();
        if (jarEntry.isDirectory() || jarEntryName.startsWith("module-info") || jarEntryName.startsWith("package-info") || !jarEntryName.endsWith(".class")) {
            return;
        }
        if (StringUtils.isNotEmpty(packageName) && !jarEntryName.startsWith(packageName) && !jarEntryName.startsWith("cn.taketoday")) {
            return;
        }
        try {
            scanClasses.add(classLoader.loadClass(jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replaceAll("/", ".")));
        }
        catch (ClassNotFoundException | NoClassDefFoundError | UnsupportedClassVersionError throwable) {
            // empty catch block
        }
    }

    private static void findAllClassWithPackage(String packageName, String packagePath, Collection<Class<?>> scanClasses) {
        File directory = new File(packagePath);
        if (!directory.exists() || !directory.isDirectory()) {
            log.error("The package -> [{}] you provided that contains nothing", (Object)packageName);
            return;
        }
        File[] directoryFiles = directory.listFiles(CLASS_FILE_FILTER);
        if (directoryFiles == null) {
            log.error("The package -> [{}] you provided that contains nothing", (Object)packageName);
            return;
        }
        ClassLoader classLoader = ClassUtils.getClassLoader();
        int length = ".class".length();
        for (File file : directoryFiles) {
            String fileName = file.getName();
            if (file.isDirectory()) {
                String scanPackage = packageName + "." + fileName;
                if (scanPackage.startsWith(".")) {
                    scanPackage = scanPackage.replaceFirst("[.]", "");
                }
                ClassUtils.findAllClassWithPackage(scanPackage, file.getAbsolutePath(), scanClasses);
                continue;
            }
            if (fileName.contains("package-info")) continue;
            String className = (packageName + "." + fileName.substring(0, fileName.length() - length)).replaceAll("/", ".");
            try {
                scanClasses.add(classLoader.loadClass(className));
            }
            catch (ClassNotFoundException | NoClassDefFoundError | UnsupportedClassVersionError throwable) {
                // empty catch block
            }
        }
    }

    private static boolean sameType(Type[] types, Class<?>[] classes) {
        if (types.length != classes.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (Type.getType(classes[i]).equals(types[i])) continue;
            return false;
        }
        return true;
    }

    public static String[] getMethodArgsNames(final Method method) throws IOException {
        final String[] paramNames = new String[method.getParameterCount()];
        try (InputStream resourceAsStream = classLoader.getResourceAsStream(method.getDeclaringClass().getName().replace('.', '/') + ".class");){
            new ClassReader(resourceAsStream).accept(new ClassVisitor(458752){

                @Override
                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    Type[] args = Type.getArgumentTypes(desc);
                    if (!name.equals(method.getName()) || !ClassUtils.sameType(args, method.getParameterTypes())) {
                        return super.visitMethod(access, name, desc, signature, exceptions);
                    }
                    return new MethodVisitor(458752, super.visitMethod(access, name, desc, signature, exceptions)){

                        @Override
                        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                            if (!Modifier.isStatic(method.getModifiers())) {
                                --index;
                            }
                            if (index >= 0 && index < paramNames.length) {
                                paramNames[index] = name;
                            }
                            super.visitLocalVariable(name, desc, signature, start, end, index);
                        }
                    };
                }
            }, 0);
        }
        return paramNames;
    }

    public static <T extends Annotation> T[] getAnnotationArray(AnnotatedElement annotatedElement, Class<T> annotationClass, Class<? extends T> implClass) {
        return ClassUtils.getAnnotation(annotatedElement, annotationClass, implClass).toArray((Annotation[])Array.newInstance(annotationClass, 0));
    }

    public static <T extends Annotation> T[] getAnnotationArray(AnnotatedElement annotatedElement, Class<T> annotationClass) {
        return ClassUtils.getAnnotation(annotatedElement, annotationClass).toArray((Annotation[])Array.newInstance(annotationClass, 0));
    }

    public static <T extends Annotation> Collection<T> getAnnotation(AnnotatedElement annotatedElement, Class<T> annotationClass, Class<? extends T> implClass) {
        try {
            LinkedList<Annotation> result = new LinkedList<Annotation>();
            for (AnnotationAttributes attributes : ClassUtils.getAnnotationAttributes(annotatedElement, annotationClass)) {
                Annotation instance = (Annotation)implClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                for (Method method : annotationClass.getDeclaredMethods()) {
                    String name = method.getName();
                    Field declaredField = implClass.getDeclaredField(name);
                    declaredField.setAccessible(true);
                    declaredField.set(instance, attributes.get(name));
                }
                result.add(instance);
            }
            return result;
        }
        catch (NoSuchFieldException e) {
            log.error("You must specify a field: [{}] in class: [{}]", new Object[]{e.getMessage(), implClass.getName(), e});
            throw new ContextException(e);
        }
        catch (Throwable ex) {
            ex = ExceptionUtils.unwrapThrowable(ex);
            log.error("An Exception Occurred When Getting Annotation, With Msg: [{}]", (Object)ex.getMessage(), (Object)ex);
            throw new ContextException(ex);
        }
    }

    public static AnnotationAttributes getAnnotationAttributes(Annotation annotation) {
        AnnotationAttributes attributes = null;
        try {
            Method[] declaredMethods = annotation.annotationType().getDeclaredMethods();
            attributes = new AnnotationAttributes(annotation.annotationType(), declaredMethods.length);
            for (Method method : declaredMethods) {
                attributes.put(method.getName(), method.invoke((Object)annotation, new Object[0]));
            }
        }
        catch (Throwable ex) {
            ex = ExceptionUtils.unwrapThrowable(ex);
            log.error("An Exception Occurred When Getting Annotation Attributes, With Msg: [{}]", (Object)ex.getMessage(), (Object)ex);
            throw new ContextException(ex);
        }
        return attributes;
    }

    public static <T extends Annotation> Collection<T> getAnnotation(AnnotatedElement annotatedElement, Class<T> annotationClass) {
        Objects.requireNonNull(annotationClass, "annotation class can't be null");
        LinkedList<T> annotations = new LinkedList<T>();
        for (AnnotationAttributes attributes : ClassUtils.getAnnotationAttributes(annotatedElement, annotationClass)) {
            annotations.add(ClassUtils.getAnnotationProxy(annotationClass, attributes));
        }
        return annotations;
    }

    public static <T extends Annotation> T getAnnotationProxy(Class<T> annotationClass, AnnotationAttributes attributes) {
        return (T)((Annotation)annotationClass.cast(Proxy.newProxyInstance(classLoader, new Class[]{annotationClass, Annotation.class}, (proxy, method, args) -> {
            switch (method.getName()) {
                case "equals": {
                    return ClassUtils.eq(attributes, args);
                }
                case "hashCode": {
                    return attributes.hashCode();
                }
                case "toString": {
                    return attributes.toString();
                }
                case "annotationType": {
                    return annotationClass;
                }
            }
            return attributes.get(method.getName());
        })));
    }

    private static Object eq(AnnotationAttributes attributes, Object[] args) throws IllegalAccessException, InvocationTargetException {
        Object object = args[0];
        if (attributes == object) {
            return true;
        }
        if (object instanceof Annotation) {
            for (Method method_ : object.getClass().getDeclaredMethods()) {
                Object value_ = attributes.get(method_.getName());
                Object value = method_.invoke(object, new Object[0]);
                if (value != null && value_ != null && value.equals(value_)) continue;
                return false;
            }
            return true;
        }
        if (object instanceof AnnotationAttributes) {
            return object.equals(attributes);
        }
        return false;
    }

    public static <T extends Annotation> Collection<AnnotationAttributes> getAnnotationAttributes(AnnotatedElement annotatedElement, Class<T> annotationClass) {
        Objects.requireNonNull(annotatedElement, "annotated element can't be null");
        HashSet<AnnotationAttributes> result = new HashSet<AnnotationAttributes>();
        for (Annotation annotation : annotatedElement.getDeclaredAnnotations()) {
            AnnotationAttributes annotationAttributes = ClassUtils.getAnnotationAttributes(annotation, annotationClass);
            if (annotationAttributes == null) continue;
            result.add(annotationAttributes);
        }
        return result;
    }

    public static <T extends Annotation> AnnotationAttributes getAnnotationAttributes(Annotation annotation, Class<T> annotationClass) {
        try {
            if (annotation == null) {
                return null;
            }
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (annotationType == annotationClass) {
                return ClassUtils.getAnnotationAttributes(annotation);
            }
            if (IGNORE_ANNOTATION_CLASS.contains(annotationType)) {
                return null;
            }
            AnnotationAttributes annotationAttributes = ClassUtils.getTargetAnnotationAttributes(annotationClass, annotationType);
            if (annotationAttributes == null) {
                return null;
            }
            for (Method method : annotationType.getDeclaredMethods()) {
                String name = method.getName();
                Object value = annotationAttributes.get(name);
                if (value != null && !ClassUtils.eq(method.getReturnType(), value.getClass())) continue;
                annotationAttributes.put(name, method.invoke((Object)annotation, new Object[0]));
            }
            return annotationAttributes;
        }
        catch (Throwable ex) {
            ex = ExceptionUtils.unwrapThrowable(ex);
            log.error("An Exception Occurred When Getting Annotation Attributes, With Msg: [{}]", (Object)ex.getMessage(), (Object)ex);
            throw new ContextException(ex);
        }
    }

    private static boolean eq(Class<?> returnType, Class<?> clazz) {
        if (returnType == clazz) {
            return true;
        }
        if (returnType.isPrimitive()) {
            switch (returnType.getName()) {
                case "int": {
                    return clazz == Integer.class;
                }
                case "long": {
                    return clazz == Long.class;
                }
                case "byte": {
                    return clazz == Byte.class;
                }
                case "char": {
                    return clazz == Character.class;
                }
                case "float": {
                    return clazz == Float.class;
                }
                case "double": {
                    return clazz == Double.class;
                }
                case "short": {
                    return clazz == Short.class;
                }
                case "boolean": {
                    return clazz == Boolean.class;
                }
            }
        }
        return false;
    }

    public static <T extends Annotation> AnnotationAttributes getTargetAnnotationAttributes(Class<T> targetAnnotationType, Class<? extends Annotation> annotationType) {
        for (Annotation currentAnnotation : annotationType.getAnnotations()) {
            if (IGNORE_ANNOTATION_CLASS.contains(currentAnnotation.annotationType())) continue;
            if (currentAnnotation.annotationType() == targetAnnotationType) {
                return ClassUtils.getAnnotationAttributes(currentAnnotation);
            }
            AnnotationAttributes attributes = ClassUtils.getTargetAnnotationAttributes(targetAnnotationType, currentAnnotation.annotationType());
            if (attributes == null) continue;
            return attributes;
        }
        return null;
    }

    public static <T> T newInstance(Class<T> beanClass) {
        try {
            return beanClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new ContextException(e);
        }
    }

    public static <T> T newInstance(String beanClassName) {
        try {
            return (T)ClassUtils.forName(beanClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new ContextException(e);
        }
    }

    public static Collection<Field> getFields(Class<?> targetClass) {
        ArrayList<Field> list = new ArrayList<Field>(64);
        do {
            for (Field field : targetClass.getDeclaredFields()) {
                list.add(field);
            }
        } while ((targetClass = targetClass.getSuperclass()) != Object.class && targetClass != null);
        return list;
    }

    public static Field[] getFieldArray(Class<?> targetClass) {
        return ClassUtils.getFields(targetClass).toArray(new Field[0]);
    }

    public static void clearCache() {
        ClassUtils.setClassCache(null);
    }

    public static void setClassLoader(ClassLoader classLoader) {
        ClassUtils.classLoader = classLoader;
    }

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    public static Collection<Class<?>> getClassCache() {
        if (classesCache == null || classesCache.isEmpty()) {
            ClassUtils.setClassCache(ClassUtils.scan(""));
        }
        return classesCache;
    }

    public static void setClassCache(Collection<Class<?>> classes) {
        classesCache = classes;
    }

    static {
        classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassUtils.class.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        IGNORE_ANNOTATION_CLASS = new HashSet<Class<? extends Annotation>>(4, 1.0f){
            {
                this.add(Target.class);
                this.add(Inherited.class);
                this.add(Retention.class);
                this.add(Documented.class);
            }
        };
        CLASS_FILE_FILTER = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".class");
            }
        };
    }
}

