/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.loader;

import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.annotation.Value;
import cn.taketoday.context.bean.PropertyValue;
import cn.taketoday.context.loader.PropertyValueResolver;
import cn.taketoday.context.utils.ContextUtils;
import cn.taketoday.context.utils.ConvertUtils;
import cn.taketoday.context.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.Properties;

public class ValuePropertyResolver
implements PropertyValueResolver {
    @Override
    public PropertyValue resolveProperty(ApplicationContext applicationContext, Field field) {
        String value_ = null;
        Value annotation = field.getAnnotation(Value.class);
        String value = annotation.value();
        Properties properties = applicationContext.getEnvironment().getProperties();
        value_ = StringUtils.isNotEmpty(value) ? ContextUtils.resolvePlaceholder(properties, value, annotation.required()) : properties.getProperty(field.getName());
        if (value_ == null) {
            return null;
        }
        return new PropertyValue(ConvertUtils.convert(value_, field.getType()), field);
    }
}

