/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.loader;

import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.annotation.Props;
import cn.taketoday.context.bean.PropertyValue;
import cn.taketoday.context.exception.AnnotationException;
import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.exception.ContextException;
import cn.taketoday.context.loader.PropertyValueResolver;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ContextUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Properties;

public class PropsPropertyResolver
implements PropertyValueResolver {
    @Override
    public PropertyValue resolveProperty(ApplicationContext applicationContext, Field field) {
        if (!Properties.class.equals(field.getType()) && !Map.class.equals(field.getType())) {
            throw new AnnotationException("Field: [" + field + "] type must be: [" + Properties.class.getName() + "] or [" + Map.class.getName() + "]");
        }
        Props props = field.getAnnotation(Props.class);
        Properties properties = new Properties();
        Properties properties_ = new Properties();
        ClassLoader classLoader = ClassUtils.getClassLoader();
        for (String fileName : props.value()) {
            try (FileInputStream inputStream = new FileInputStream(classLoader.getResource(this.checkName(fileName)).getPath());){
                properties_.load(inputStream);
                this.load(props, properties, properties_);
            }
            catch (IOException e) {
                throw new ContextException(e);
            }
        }
        if (props.value().length == 0) {
            this.load(props, properties, applicationContext.getEnvironment().getProperties());
        }
        return new PropertyValue(properties, field);
    }

    private void load(Props props, Map<Object, Object> properties, Properties pool) {
        String[] prefix = props.prefix();
        boolean replace = props.replace();
        try {
            for (Map.Entry<Object, Object> entry : pool.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (!(key instanceof String)) continue;
                for (String prefix_ : prefix) {
                    if (!((String)key).startsWith(prefix_)) continue;
                    if (replace) {
                        key = ((String)key).replaceFirst(prefix_, "");
                    }
                    properties.put((String)key, ContextUtils.resolvePlaceholder(pool, (String)value));
                }
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    private final String checkName(String fileName) {
        return fileName.endsWith(".properties") ? fileName : fileName + ".properties";
    }
}

