/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.loader;

import cn.taketoday.context.AnnotationAttributes;
import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.BeanNameCreator;
import cn.taketoday.context.ConfigurableApplicationContext;
import cn.taketoday.context.Scope;
import cn.taketoday.context.annotation.Component;
import cn.taketoday.context.bean.BeanDefinition;
import cn.taketoday.context.bean.DefaultBeanDefinition;
import cn.taketoday.context.env.ConfigurableEnvironment;
import cn.taketoday.context.exception.BeanDefinitionStoreException;
import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.factory.BeanDefinitionRegistry;
import cn.taketoday.context.factory.FactoryBean;
import cn.taketoday.context.loader.BeanDefinitionLoader;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ContextUtils;
import cn.taketoday.context.utils.ExceptionUtils;
import cn.taketoday.context.utils.StringUtils;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Objects;

public class DefaultBeanDefinitionLoader
implements BeanDefinitionLoader {
    private final BeanDefinitionRegistry registry;
    private final ConfigurableApplicationContext applicationContext;
    private final BeanNameCreator beanNameCreator;

    public DefaultBeanDefinitionLoader(ConfigurableApplicationContext applicationContext) {
        Objects.requireNonNull(applicationContext, "applicationContext can't be null");
        this.applicationContext = applicationContext;
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        environment.setBeanDefinitionLoader(this);
        this.registry = applicationContext;
        this.beanNameCreator = environment.getBeanNameCreator();
    }

    @Override
    public BeanDefinitionRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void loadBeanDefinition(Class<?> beanClass) throws BeanDefinitionStoreException {
        if (Modifier.isAbstract(beanClass.getModifiers())) {
            return;
        }
        try {
            if (ContextUtils.conditional(beanClass, this.applicationContext)) {
                this.register(beanClass);
            }
        }
        catch (Throwable ex) {
            throw new BeanDefinitionStoreException(ExceptionUtils.unwrapThrowable(ex));
        }
    }

    @Override
    public void loadBeanDefinitions(Collection<Class<?>> beans) throws BeanDefinitionStoreException {
        for (Class<?> clazz : beans) {
            this.loadBeanDefinition(clazz);
        }
    }

    @Override
    public void loadBeanDefinition(String name, Class<?> beanClass) throws BeanDefinitionStoreException {
        try {
            Collection<AnnotationAttributes> annotationAttributes = ClassUtils.getAnnotationAttributes(beanClass, Component.class);
            if (annotationAttributes.isEmpty()) {
                this.register(name, this.build(beanClass, null, name));
            } else {
                for (AnnotationAttributes attributes : annotationAttributes) {
                    this.register(name, this.build(beanClass, attributes, name));
                }
            }
        }
        catch (Throwable e) {
            throw new BeanDefinitionStoreException(ExceptionUtils.unwrapThrowable(e));
        }
    }

    @Override
    public void register(Class<?> beanClass) throws BeanDefinitionStoreException {
        try {
            Collection<AnnotationAttributes> annotationAttributes = ClassUtils.getAnnotationAttributes(beanClass, Component.class);
            if (annotationAttributes.isEmpty()) {
                return;
            }
            String defaultBeanName = this.beanNameCreator.create(beanClass);
            for (AnnotationAttributes attributes : annotationAttributes) {
                for (String name : ContextUtils.findNames(defaultBeanName, attributes.getStringArray("value"))) {
                    if (this.applicationContext.containsBeanDefinition(name)) continue;
                    this.register(name, this.build(beanClass, attributes, name));
                }
            }
        }
        catch (Throwable ex) {
            ex = ExceptionUtils.unwrapThrowable(ex);
            throw new ConfigurationException("An Exception Occurred When Build Bean Definition: [{}], With Msg: [{}] ", beanClass, ex.getMessage(), ex);
        }
    }

    private BeanDefinition build(Class<?> beanClass, AnnotationAttributes attributes, String name) throws Throwable {
        DefaultBeanDefinition beanDefinition = new DefaultBeanDefinition(name, beanClass);
        if (attributes == null) {
            beanDefinition.setDestroyMethods(new String[0]).setInitMethods(ContextUtils.resolveInitMethod(beanClass, new String[0]));
        } else {
            beanDefinition.setScope((Scope)((Object)attributes.getEnum("scope"))).setDestroyMethods(attributes.getStringArray("destroyMethods")).setInitMethods(ContextUtils.resolveInitMethod(beanClass, attributes.getStringArray("initMethods")));
        }
        beanDefinition.setPropertyValues(ContextUtils.resolvePropertyValue(beanClass, (ApplicationContext)this.applicationContext));
        ContextUtils.resolveProps(beanDefinition, this.applicationContext.getEnvironment());
        return beanDefinition;
    }

    @Override
    public void register(String name, BeanDefinition beanDefinition) throws BeanDefinitionStoreException {
        try {
            ContextUtils.validateBeanDefinition(beanDefinition, this.applicationContext);
            if (FactoryBean.class.isAssignableFrom(beanDefinition.getBeanClass())) {
                name = this.registerFactoryBean(name, beanDefinition);
            }
            this.registry.registerBeanDefinition(name, beanDefinition);
        }
        catch (Throwable ex) {
            throw new BeanDefinitionStoreException("An Exception Occurred When Register Bean Definition: [{}], With Msg: [{}]", name, ex.getMessage(), ExceptionUtils.unwrapThrowable(ex));
        }
    }

    private String registerFactoryBean(String beanName, BeanDefinition beanDefinition) throws Throwable {
        ConfigurableApplicationContext applicationContext = this.applicationContext;
        FactoryBean $factoryBean = (FactoryBean)applicationContext.getSingleton("$" + beanName);
        boolean registed = true;
        if ($factoryBean == null) {
            $factoryBean = (FactoryBean)ClassUtils.newInstance(beanDefinition.getBeanClass());
            registed = false;
        }
        if (StringUtils.isEmpty(beanName = $factoryBean.getBeanName())) {
            beanName = this.beanNameCreator.create($factoryBean.getBeanClass());
        }
        beanDefinition.setFactoryBean(true);
        if (StringUtils.isEmpty(beanDefinition.getName())) {
            beanDefinition.setName(beanName);
        }
        if (!registed) {
            applicationContext.registerSingleton(beanName, $factoryBean);
        }
        return beanName;
    }

    @Override
    public BeanDefinition createBeanDefinition(Class<?> beanClass) {
        BeanDefinition beanDefinition = new DefaultBeanDefinition(this.beanNameCreator.create(beanClass), beanClass).setDestroyMethods(new String[0]).setAbstract(Modifier.isAbstract(beanClass.getModifiers())).setFactoryBean(FactoryBean.class.isAssignableFrom(beanClass));
        try {
            ContextUtils.resolveProps(beanDefinition, this.applicationContext.getEnvironment());
            return beanDefinition.setInitMethods(ContextUtils.resolveInitMethod(beanClass, new String[0])).setPropertyValues(ContextUtils.resolvePropertyValue(beanClass, (ApplicationContext)this.applicationContext));
        }
        catch (Throwable ex) {
            ex = ExceptionUtils.unwrapThrowable(ex);
            throw new BeanDefinitionStoreException("An Exception Occurred When Create A Bean Definition, With Msg: [{}]", ex.getMessage(), ex);
        }
    }
}

