/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.loader;

import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.BeanNameCreator;
import cn.taketoday.context.annotation.Autowired;
import cn.taketoday.context.bean.BeanDefinition;
import cn.taketoday.context.bean.BeanReference;
import cn.taketoday.context.bean.PropertyValue;
import cn.taketoday.context.loader.PropertyValueResolver;
import cn.taketoday.context.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.Map;
import javax.annotation.Resource;

public class AutowiredPropertyResolver
implements PropertyValueResolver {
    private BeanNameCreator beanNameCreator;

    @Override
    public PropertyValue resolveProperty(ApplicationContext applicationContext, Field field) {
        if (this.beanNameCreator == null) {
            this.beanNameCreator = applicationContext.getEnvironment().getBeanNameCreator();
        }
        Autowired autowired = field.getAnnotation(Autowired.class);
        boolean required = true;
        Class<?> propertyClass = field.getType();
        String name = null;
        if (autowired != null) {
            name = StringUtils.isNotEmpty(autowired.value()) ? autowired.value() : this.byType(applicationContext, propertyClass);
            required = autowired.required();
        }
        if (StringUtils.isEmpty(name) && field.isAnnotationPresent(Resource.class)) {
            Resource resource = field.getAnnotation(Resource.class);
            name = StringUtils.isNotEmpty(resource.name()) ? resource.name() : (resource.type() != Object.class ? this.byType(applicationContext, propertyClass) : this.beanNameCreator.create(propertyClass));
        }
        return new PropertyValue(new BeanReference().setName(name).setRequired(required).setReferenceClass(propertyClass), field);
    }

    private String byType(ApplicationContext applicationContext, Class<?> targetClass) {
        String name;
        if (applicationContext.hasStarted() && StringUtils.isNotEmpty(name = this.findName(applicationContext, targetClass))) {
            return name;
        }
        return this.beanNameCreator.create(targetClass);
    }

    private String findName(ApplicationContext applicationContext, Class<?> propertyClass) {
        for (Map.Entry<String, BeanDefinition> entry : applicationContext.getBeanDefinitionsMap().entrySet()) {
            if (!propertyClass.isAssignableFrom(entry.getValue().getBeanClass())) continue;
            return entry.getKey();
        }
        return null;
    }
}

