/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.listener;

import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.annotation.ContextListener;
import cn.taketoday.context.annotation.Order;
import cn.taketoday.context.env.ConfigurableEnvironment;
import cn.taketoday.context.event.ContextCloseEvent;
import cn.taketoday.context.factory.BeanDefinitionRegistry;
import cn.taketoday.context.listener.ApplicationListener;
import cn.taketoday.context.utils.ClassUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ContextListener
@Order(value=-1073741823)
public class ContextCloseListener
implements ApplicationListener<ContextCloseEvent> {
    private static final Logger log = LoggerFactory.getLogger(ContextCloseListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onApplicationEvent(ContextCloseEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        log.info("Closing: [{}] at [{}]", (Object)applicationContext, (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(event.getTimestamp())));
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        BeanDefinitionRegistry beanDefinitionRegistry = environment.getBeanDefinitionRegistry();
        try {
            for (String name : applicationContext.getBeanDefinitionsMap().keySet()) {
                applicationContext.destroyBean(name);
            }
        }
        finally {
            ClassUtils.clearCache();
            applicationContext.getSingletonsMap().clear();
            beanDefinitionRegistry.getBeanDefinitionsMap().clear();
        }
    }
}

