/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.factory;

import cn.taketoday.context.BeanNameCreator;
import cn.taketoday.context.bean.BeanDefinition;
import cn.taketoday.context.bean.BeanReference;
import cn.taketoday.context.bean.DefaultBeanDefinition;
import cn.taketoday.context.bean.PropertyValue;
import cn.taketoday.context.exception.BeanDefinitionStoreException;
import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.exception.ContextException;
import cn.taketoday.context.exception.NoSuchBeanDefinitionException;
import cn.taketoday.context.factory.BeanPostProcessor;
import cn.taketoday.context.factory.ConfigurableBeanFactory;
import cn.taketoday.context.factory.DisposableBean;
import cn.taketoday.context.factory.FactoryBean;
import cn.taketoday.context.factory.InitializingBean;
import cn.taketoday.context.loader.BeanDefinitionLoader;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ContextUtils;
import cn.taketoday.context.utils.ExceptionUtils;
import cn.taketoday.context.utils.OrderUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBeanFactory
implements ConfigurableBeanFactory {
    private static final Logger log = LoggerFactory.getLogger(AbstractBeanFactory.class);
    private BeanNameCreator beanNameCreator;
    private final Set<PropertyValue> dependencies = new HashSet<PropertyValue>(32, 1.0f);
    private final List<BeanPostProcessor> postProcessors = new LinkedList<BeanPostProcessor>();
    private final Map<String, Object> singletons = new ConcurrentHashMap<String, Object>(64, 1.0f);
    private final Map<String, BeanDefinition> beanDefinitionMap = new ConcurrentHashMap<String, BeanDefinition>(64, 1.0f);

    @Override
    public Object getBean(String name) throws NoSuchBeanDefinitionException {
        BeanDefinition beanDefinition;
        Object bean = this.singletons.get(name);
        if (bean == null && (beanDefinition = this.getBeanDefinition(name)) != null) {
            try {
                if (beanDefinition.isSingleton()) {
                    return this.doCreateBean(beanDefinition, name);
                }
                return this.doCreatePrototype(beanDefinition, name);
            }
            catch (Throwable ex) {
                ex = ExceptionUtils.unwrapThrowable(ex);
                log.error("An Exception Occurred When Getting A Bean Named: [{}], With Msg: [{}]", new Object[]{name, ex.getMessage(), ex});
            }
        }
        return bean;
    }

    protected Object doCreatePrototype(BeanDefinition beanDefinition, String name) throws Throwable {
        if (beanDefinition.isFactoryBean()) {
            FactoryBean $factoryBean = (FactoryBean)this.initializingBean(this.singletons.get("$" + name), name, beanDefinition);
            return $factoryBean.getBean();
        }
        return this.initializingBean(this.createBeanInstance(beanDefinition), name, beanDefinition);
    }

    @Override
    public <T> T getBean(Class<T> requiredType) throws NoSuchBeanDefinitionException {
        return this.getBean(this.getBeanNameCreator().create(requiredType), requiredType);
    }

    <T> Object doGetBeanforType(Class<T> requiredType) {
        Object bean = null;
        for (Map.Entry<String, BeanDefinition> entry : this.getBeanDefinitionsMap().entrySet()) {
            if (requiredType.isAssignableFrom(entry.getValue().getBeanClass()) && (bean = this.getBean(entry.getKey())) != null) break;
        }
        return bean;
    }

    @Override
    public <T> T getBean(String name, Class<T> requiredType) throws NoSuchBeanDefinitionException {
        Object bean = this.getBean(name);
        if (bean != null && requiredType.isInstance(bean)) {
            return requiredType.cast(bean);
        }
        return requiredType.cast(this.doGetBeanforType(requiredType));
    }

    @Override
    public <T> List<T> getBeans(Class<T> requiredType) {
        ArrayList<Object> beans = new ArrayList<Object>();
        for (Map.Entry<String, BeanDefinition> entry : this.getBeanDefinitionsMap().entrySet()) {
            Object bean;
            if (!requiredType.isAssignableFrom(entry.getValue().getBeanClass()) || (bean = this.getBean(entry.getKey())) == null) continue;
            beans.add(bean);
        }
        return beans;
    }

    protected Object createBeanInstance(BeanDefinition beanDefinition) throws Throwable {
        Object bean = this.getSingleton(beanDefinition.getName());
        if (bean == null) {
            bean = ClassUtils.newInstance(beanDefinition.getBeanClass());
        }
        return bean;
    }

    protected void applyPropertyValues(Object bean, PropertyValue ... propertyValues) throws IllegalAccessException {
        for (PropertyValue propertyValue : propertyValues) {
            BeanReference beanReference;
            Object value = propertyValue.getValue();
            if (value instanceof BeanReference && (value = this.getBean((beanReference = (BeanReference)value).getName(), beanReference.getReferenceClass())) == null) {
                if (!beanReference.isRequired()) continue;
                log.error("[{}] is required.", (Object)propertyValue.getField());
                throw new NoSuchBeanDefinitionException(beanReference.getName());
            }
            propertyValue.getField().set(bean, value);
        }
    }

    protected void invokeInitMethods(Object bean, Method ... methods) throws Exception {
        for (Method method : methods) {
            method.invoke(bean, ContextUtils.resolveParameter(method, this));
        }
        if (bean instanceof InitializingBean) {
            ((InitializingBean)bean).afterPropertiesSet();
        }
    }

    protected Object doCreateBean(BeanDefinition beanDefinition, String name) throws Throwable {
        if (beanDefinition.isFactoryBean()) {
            FactoryBean $factoryBean = (FactoryBean)this.singletons.get("$" + name);
            if (!beanDefinition.isInitialized()) {
                $factoryBean = (FactoryBean)this.initializingBean($factoryBean, name, beanDefinition);
            }
            Object bean = $factoryBean.getBean();
            if (beanDefinition.isSingleton()) {
                beanDefinition.setInitialized(true);
                this.singletons.put(name, bean);
            }
            return bean;
        }
        return this.doCreate(name, beanDefinition);
    }

    protected void doCreateSingleton(Map.Entry<String, BeanDefinition> entry, Set<Map.Entry<String, BeanDefinition>> entrySet) throws Throwable {
        String name = entry.getKey();
        BeanDefinition beanDefinition = entry.getValue();
        if (!beanDefinition.isSingleton() || beanDefinition.isInitialized()) {
            return;
        }
        if (beanDefinition.isFactoryBean()) {
            log.debug("[{}] is FactoryBean", (Object)name);
            FactoryBean $factoryBean = (FactoryBean)this.initializingBean(this.singletons.get("$" + name), name, beanDefinition);
            beanDefinition.setInitialized(true);
            this.singletons.put(name, $factoryBean.getBean());
            return;
        }
        if (this.createAbstractInstance(entrySet, name, beanDefinition)) {
            return;
        }
        this.initializeSingleton(name, beanDefinition);
    }

    protected Object doCreate(String currentBeanName, BeanDefinition currentBeanDefinition) throws Throwable {
        if (!currentBeanDefinition.isAbstract()) {
            return this.initializeSingleton(currentBeanName, currentBeanDefinition);
        }
        Class<?> currentBeanClass = currentBeanDefinition.getBeanClass();
        for (Map.Entry<String, BeanDefinition> entry_ : this.getBeanDefinitionsMap().entrySet()) {
            BeanDefinition childBeanDefinition = entry_.getValue();
            String childName = childBeanDefinition.getName();
            if (!currentBeanClass.isAssignableFrom(childBeanDefinition.getBeanClass()) || childName.equals(currentBeanName)) continue;
            log.debug("Found The Implementation Of [{}] Bean: [{}].", (Object)currentBeanName, (Object)childName);
            Object childSingleton = this.singletons.get(childName);
            try {
                if (childSingleton == null) {
                    childSingleton = this.createBeanInstance(childBeanDefinition);
                }
                if (!childBeanDefinition.isInitialized()) {
                    log.debug("Initialize The Implementation Of [{}] Bean: [{}]", (Object)currentBeanName, (Object)childName);
                    childSingleton = this.initializingBean(childSingleton, childName, childBeanDefinition);
                    this.singletons.put(childName, childSingleton);
                    childBeanDefinition.setInitialized(true);
                    currentBeanDefinition.setInitialized(true);
                }
                this.singletons.put(currentBeanName, childSingleton);
                return childSingleton;
            }
            catch (Throwable e) {
                e = ExceptionUtils.unwrapThrowable(e);
                childBeanDefinition.setInitialized(false);
                throw new BeanDefinitionStoreException("Can't store bean named: [" + currentBeanDefinition.getName() + "] With Msg: [" + e.getMessage() + "]", e);
            }
        }
        return this.initializeSingleton(currentBeanName, currentBeanDefinition);
    }

    protected Object initializeSingleton(String name, BeanDefinition beanDefinition) throws Throwable {
        Object bean = this.initializingBean(this.createBeanInstance(beanDefinition), name, beanDefinition);
        log.debug("Singleton bean is being stored in the name of [{}]", (Object)name);
        this.singletons.put(name, bean);
        beanDefinition.setInitialized(true);
        return bean;
    }

    protected boolean createAbstractInstance(Set<Map.Entry<String, BeanDefinition>> entrySet, String currentBeanName, BeanDefinition currentBeanDefinition) {
        if (!currentBeanDefinition.isAbstract()) {
            return false;
        }
        Class<?> currentBeanClass = currentBeanDefinition.getBeanClass();
        for (Map.Entry<String, BeanDefinition> entry_ : entrySet) {
            BeanDefinition childBeanDefinition = entry_.getValue();
            String childName = childBeanDefinition.getName();
            if (!currentBeanClass.isAssignableFrom(childBeanDefinition.getBeanClass()) || childName.equals(currentBeanName)) continue;
            log.debug("Found The Implementation Of [{}] Bean [{}].", (Object)currentBeanName, (Object)childName);
            Object childSingleton = this.singletons.get(childName);
            try {
                if (childSingleton == null) {
                    childSingleton = this.createBeanInstance(childBeanDefinition);
                }
                if (!childBeanDefinition.isInitialized()) {
                    log.debug("Initialize The Implementation Of [{}] Bean : [{}] .", (Object)currentBeanName, (Object)childName);
                    childSingleton = this.initializingBean(childSingleton, childName, childBeanDefinition);
                    this.singletons.put(childName, childSingleton);
                    childBeanDefinition.setInitialized(true);
                    currentBeanDefinition.setInitialized(true);
                }
                if (!this.singletons.containsKey(currentBeanName)) {
                    log.debug("Singleton bean is being stored in the name of [{}].", (Object)currentBeanName);
                    this.singletons.put(currentBeanName, childSingleton);
                }
                return true;
            }
            catch (Throwable e) {
                e = ExceptionUtils.unwrapThrowable(e);
                childBeanDefinition.setInitialized(false);
                throw new BeanDefinitionStoreException("Can't store bean named: [" + currentBeanDefinition.getName() + "] With Msg: [" + e.getMessage() + "]", e);
            }
        }
        return false;
    }

    public void registerBeanPostProcessors() {
        log.debug("Start loading BeanPostProcessor.");
        try {
            List<BeanPostProcessor> postProcessors = this.postProcessors;
            for (Map.Entry<String, BeanDefinition> entry : this.getBeanDefinitionsMap().entrySet()) {
                BeanDefinition beanDefinition = entry.getValue();
                if (!BeanPostProcessor.class.isAssignableFrom(beanDefinition.getBeanClass())) continue;
                log.debug("Find a BeanPostProcessor: [{}]", beanDefinition.getBeanClass());
                postProcessors.add((BeanPostProcessor)this.initializeSingleton(entry.getKey(), beanDefinition));
            }
            OrderUtils.reversedSort(postProcessors);
        }
        catch (Throwable ex) {
            ex = ExceptionUtils.unwrapThrowable(ex);
            log.error("An Exception Occurred When Adding Post Processor To Context: [{}] With Msg: [{}]", new Object[]{this, ex.getMessage(), ex});
            throw new ContextException(ex);
        }
    }

    public void handleDependency() {
        Set<Map.Entry<String, BeanDefinition>> entrySet = this.getBeanDefinitionsMap().entrySet();
        block0: for (PropertyValue propertyValue : this.getDependencies()) {
            Class<?> propertyType = propertyValue.getField().getType();
            if (!Modifier.isAbstract(propertyType.getModifiers())) continue;
            String beanName = ((BeanReference)propertyValue.getValue()).getName();
            BeanDefinition registedBeanDefinition = this.getBeanDefinition(beanName);
            if (registedBeanDefinition != null) {
                registedBeanDefinition.setAbstract(true);
                continue;
            }
            for (Map.Entry<String, BeanDefinition> entry : entrySet) {
                BeanDefinition beanDefinition = entry.getValue();
                if (!propertyType.isAssignableFrom(beanDefinition.getBeanClass())) continue;
                this.registerBeanDefinition(beanName, new DefaultBeanDefinition().setAbstract(true).setName(beanName).setScope(beanDefinition.getScope()).setBeanClass(beanDefinition.getBeanClass()).setInitMethods(beanDefinition.getInitMethods()).setDestroyMethods(beanDefinition.getDestroyMethods()).setPropertyValues(beanDefinition.getPropertyValues()));
                continue block0;
            }
        }
    }

    protected Object initializingBean(Object bean, String name, BeanDefinition beanDefinition) throws Exception {
        log.debug("Initializing bean named: [{}].", (Object)name);
        this.aware(bean, name);
        if (!this.postProcessors.isEmpty()) {
            return this.initWithPostProcessors(bean, name, beanDefinition, this.postProcessors);
        }
        this.applyPropertyValues(bean, beanDefinition.getPropertyValues());
        this.invokeInitMethods(bean, beanDefinition.getInitMethods());
        return bean;
    }

    private Object initWithPostProcessors(Object bean, String name, BeanDefinition beanDefinition, List<BeanPostProcessor> postProcessors) throws Exception {
        for (BeanPostProcessor postProcessor : postProcessors) {
            bean = postProcessor.postProcessBeforeInitialization(bean, beanDefinition);
        }
        this.applyPropertyValues(bean, beanDefinition.getPropertyValues());
        this.invokeInitMethods(bean, beanDefinition.getInitMethods());
        for (BeanPostProcessor postProcessor : postProcessors) {
            bean = postProcessor.postProcessAfterInitialization(bean, name);
        }
        return bean;
    }

    protected abstract void aware(Object var1, String var2);

    @Override
    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return !this.isPrototype(name);
    }

    @Override
    public boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
        BeanDefinition beanDefinition = this.getBeanDefinition(name);
        if (beanDefinition == null) {
            throw new NoSuchBeanDefinitionException(name);
        }
        return !beanDefinition.isSingleton();
    }

    @Override
    public Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        BeanDefinition type = this.getBeanDefinition(name);
        if (type == null) {
            throw new NoSuchBeanDefinitionException(name);
        }
        return type.getBeanClass();
    }

    @Override
    public Set<String> getAliases(Class<?> type) {
        return this.getBeanDefinitionsMap().entrySet().stream().filter(entry -> type.isAssignableFrom(((BeanDefinition)entry.getValue()).getBeanClass())).map(entry -> (String)entry.getKey()).collect(Collectors.toSet());
    }

    @Override
    public void registerBean(Class<?> clazz) throws BeanDefinitionStoreException {
        this.getBeanDefinitionLoader().loadBeanDefinition(clazz);
    }

    @Override
    public void registerBean(Set<Class<?>> clazz) throws BeanDefinitionStoreException, ConfigurationException {
        this.getBeanDefinitionLoader().loadBeanDefinitions(clazz);
    }

    @Override
    public void registerBean(String name, Class<?> clazz) throws BeanDefinitionStoreException {
        this.getBeanDefinitionLoader().loadBeanDefinition(name, clazz);
    }

    @Override
    public void registerBean(String name, BeanDefinition beanDefinition) throws BeanDefinitionStoreException, ConfigurationException {
        this.getBeanDefinitionLoader().register(name, beanDefinition);
    }

    @Override
    public void addBeanPostProcessor(BeanPostProcessor beanPostProcessor) {
        this.postProcessors.remove(beanPostProcessor);
        this.postProcessors.add(beanPostProcessor);
    }

    @Override
    public void removeBeanPostProcessor(BeanPostProcessor beanPostProcessor) {
        this.postProcessors.remove(beanPostProcessor);
    }

    @Override
    public void registerSingleton(String name, Object bean) {
        if (!name.startsWith("$") && bean instanceof FactoryBean) {
            name = "$" + name;
        }
        this.singletons.put(name, bean);
    }

    @Override
    public void registerSingleton(Object bean) {
        this.registerSingleton(this.getBeanNameCreator().create(bean.getClass()), bean);
    }

    @Override
    public Map<String, Object> getSingletonsMap() {
        return this.singletons;
    }

    @Override
    public Object getSingleton(String name) {
        return this.singletons.get(name);
    }

    public <T> T getSingleton(String name, Class<T> targetClass) {
        return targetClass.cast(this.getSingleton(name));
    }

    @Override
    public void removeSingleton(String name) {
        this.singletons.remove(name);
    }

    @Override
    public void removeBean(String name) throws NoSuchBeanDefinitionException {
        this.removeBeanDefinition(name);
        this.removeSingleton(name);
    }

    @Override
    public boolean containsSingleton(String name) {
        return this.singletons.containsKey(name);
    }

    @Override
    public void registerBeanDefinition(String beanName, BeanDefinition beanDefinition) {
        this.beanDefinitionMap.put(beanName, beanDefinition);
        PropertyValue[] propertyValues = beanDefinition.getPropertyValues();
        if (propertyValues == null) {
            return;
        }
        for (PropertyValue propertyValue : propertyValues) {
            if (!(propertyValue.getValue() instanceof BeanReference)) continue;
            this.dependencies.add(propertyValue);
        }
    }

    public void destroyBean(Object beanInstance, BeanDefinition beanDefinition) {
        try {
            if (beanInstance == null || beanDefinition == null) {
                return;
            }
            Class<?> beanClass = beanInstance.getClass();
            for (String destroyMethod : beanDefinition.getDestroyMethods()) {
                beanClass.getMethod(destroyMethod, new Class[0]).invoke(beanInstance, new Object[0]);
            }
            for (Method method : beanClass.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(PreDestroy.class)) continue;
                method.invoke(beanInstance, new Object[0]);
            }
            if (beanInstance instanceof DisposableBean) {
                ((DisposableBean)beanInstance).destroy();
            }
        }
        catch (Throwable e) {
            e = ExceptionUtils.unwrapThrowable(e);
            log.error("An Exception Occurred When Destroy a bean: [{}], With Msg: [{}]", new Object[]{beanDefinition.getName(), e.getMessage(), e});
        }
    }

    @Override
    public void destroyBean(String name) {
        BeanDefinition beanDefinition = this.getBeanDefinition(name);
        if (beanDefinition == null && name.startsWith("$")) {
            String factoryBeanName = name.substring("$".length());
            beanDefinition = this.getBeanDefinition(factoryBeanName);
            this.destroyBean(this.getSingleton(factoryBeanName), beanDefinition);
            this.removeBean(factoryBeanName);
        }
        this.destroyBean(this.getSingleton(name), beanDefinition);
        this.removeBean(name);
    }

    @Override
    public String getBeanName(Class<?> targetClass) {
        for (Map.Entry<String, BeanDefinition> entry : this.getBeanDefinitionsMap().entrySet()) {
            if (entry.getValue().getBeanClass() != targetClass) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public void removeBeanDefinition(String beanName) {
        this.beanDefinitionMap.remove(beanName);
    }

    @Override
    public BeanDefinition getBeanDefinition(String beanName) {
        return this.beanDefinitionMap.get(beanName);
    }

    @Override
    public BeanDefinition getBeanDefinition(Class<?> beanClass) {
        BeanDefinition beanDefinition = this.getBeanDefinition(this.getBeanNameCreator().create(beanClass));
        if (beanDefinition != null && beanClass.isAssignableFrom(beanDefinition.getBeanClass())) {
            return beanDefinition;
        }
        for (BeanDefinition definition : this.getBeanDefinitionsMap().values()) {
            if (!beanClass.isAssignableFrom(definition.getBeanClass())) continue;
            return definition;
        }
        return null;
    }

    @Override
    public boolean containsBeanDefinition(String beanName) {
        return this.getBeanDefinitionsMap().containsKey(beanName);
    }

    @Override
    public boolean containsBeanDefinition(Class<?> type) {
        return this.containsBeanDefinition(type, false);
    }

    @Override
    public boolean containsBeanDefinition(Class<?> type, boolean equals) {
        Map<String, BeanDefinition> beanDefinitionsMap = this.getBeanDefinitionsMap();
        if (beanDefinitionsMap.containsKey(this.getBeanNameCreator().create(type))) {
            return true;
        }
        for (BeanDefinition beanDefinition : beanDefinitionsMap.values()) {
            if (!(equals ? type == beanDefinition.getBeanClass() : type.isAssignableFrom(beanDefinition.getBeanClass()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getBeanDefinitionNames() {
        return this.getBeanDefinitionsMap().keySet();
    }

    @Override
    public int getBeanDefinitionCount() {
        return this.getBeanDefinitionsMap().size();
    }

    @Override
    public Map<String, BeanDefinition> getBeanDefinitionsMap() {
        return this.beanDefinitionMap;
    }

    public Set<PropertyValue> getDependencies() {
        return this.dependencies;
    }

    @Override
    public void preInitializeSingletons() throws Throwable {
        log.debug("Initialization of singleton objects.");
        this.preInitialization();
        Set<Map.Entry<String, BeanDefinition>> entrySet = this.getBeanDefinitionsMap().entrySet();
        for (Map.Entry<String, BeanDefinition> entry : entrySet) {
            this.doCreateSingleton(entry, entrySet);
        }
        log.debug("The singleton objects are initialized.");
    }

    protected void preInitialization() throws Exception {
        for (Map.Entry<String, Object> entry : this.getSingletonsMap().entrySet()) {
            String name = entry.getKey();
            Object singleton = entry.getValue();
            BeanDefinition beanDefinition = this.getBeanDefinition(name);
            if (beanDefinition == null || beanDefinition.isInitialized()) continue;
            this.registerSingleton(name, this.initializingBean(singleton, name, beanDefinition));
            log.debug("Singleton bean is being stored in the name of [{}].", (Object)name);
            beanDefinition.setInitialized(true);
        }
    }

    @Override
    public void refresh(String name) {
        BeanDefinition beanDefinition = this.getBeanDefinition(name);
        if (beanDefinition == null) {
            throw new NoSuchBeanDefinitionException(name);
        }
        try {
            if (beanDefinition.isInitialized()) {
                log.warn("A bean named: [{}] has already initialized", (Object)name);
                return;
            }
            Object initializingBean = this.initializingBean(this.createBeanInstance(beanDefinition), name, beanDefinition);
            if (!this.containsSingleton(name)) {
                this.registerSingleton(name, initializingBean);
            }
            beanDefinition.setInitialized(true);
        }
        catch (Throwable ex) {
            throw new ContextException(ExceptionUtils.unwrapThrowable(ex));
        }
    }

    @Override
    public Object refresh(BeanDefinition beanDefinition) {
        try {
            return this.initializingBean(this.createBeanInstance(beanDefinition), beanDefinition.getName(), beanDefinition);
        }
        catch (Throwable ex) {
            throw new ContextException(ExceptionUtils.unwrapThrowable(ex));
        }
    }

    public abstract BeanDefinitionLoader getBeanDefinitionLoader();

    public abstract void setBeanDefinitionLoader(BeanDefinitionLoader var1);

    public BeanNameCreator getBeanNameCreator() {
        return this.beanNameCreator;
    }

    public void setBeanNameCreator(BeanNameCreator beanNameCreator) {
        this.beanNameCreator = beanNameCreator;
    }
}

