/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.env;

import cn.taketoday.context.BeanNameCreator;
import cn.taketoday.context.env.ConfigurableEnvironment;
import cn.taketoday.context.factory.BeanDefinitionRegistry;
import cn.taketoday.context.loader.BeanDefinitionLoader;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.StringUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardEnvironment
implements ConfigurableEnvironment {
    private static final Logger log = LoggerFactory.getLogger(StandardEnvironment.class);
    private Set<String> activeProfiles = new HashSet<String>();
    private final Properties properties = System.getProperties();
    private BeanNameCreator beanNameCreator;
    private BeanDefinitionLoader beanDefinitionLoader;
    private BeanDefinitionRegistry beanDefinitionRegistry;
    private static final FileFilter PROPERTIES_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            return name.endsWith(".properties") && !name.startsWith("pom");
        }
    };

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public boolean containsProperty(String key) {
        return this.properties.containsKey(key);
    }

    @Override
    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    @Override
    public <T> T getProperty(String key, Class<T> targetType) {
        return targetType.cast(this.properties.get(key));
    }

    @Override
    public BeanDefinitionRegistry getBeanDefinitionRegistry() {
        return this.beanDefinitionRegistry;
    }

    @Override
    public BeanDefinitionLoader getBeanDefinitionLoader() {
        return this.beanDefinitionLoader;
    }

    @Override
    public String[] getActiveProfiles() {
        return StringUtils.toStringArray(this.activeProfiles);
    }

    @Override
    public void setActiveProfiles(String ... profiles) {
        this.activeProfiles.clear();
        log.info("Active profiles: {}", (Object)Arrays.toString(profiles));
        this.activeProfiles.addAll(Arrays.asList(profiles));
    }

    @Override
    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    @Override
    public void addActiveProfile(String profile) {
        this.activeProfiles.add(profile);
    }

    @Override
    public void loadProperties(String properties) throws IOException {
        Objects.requireNonNull(properties, "Properties dir can't be null");
        URL resource = ClassUtils.getClassLoader().getResource(properties);
        if (resource == null) {
            log.warn("The path: [{}] you provided that doesn't exist", (Object)properties);
            return;
        }
        File dir = new File(resource.getPath());
        log.debug("Start loading Properties.");
        StandardEnvironment.doLoad(dir, this.properties);
        String profiles = this.getProperty("context.active.profiles");
        if (StringUtils.isNotEmpty(profiles)) {
            this.setActiveProfiles(StringUtils.split(profiles));
        }
    }

    static void doLoad(File dir, Properties properties) throws IOException {
        File[] listFiles = dir.listFiles(PROPERTIES_FILE_FILTER);
        if (listFiles == null) {
            log.warn("The path: [{}] you provided that contains nothing", (Object)dir.getAbsolutePath());
            return;
        }
        for (File file : listFiles) {
            if (file.isDirectory()) {
                StandardEnvironment.doLoad(file, properties);
                continue;
            }
            log.debug("Found Properties File: [{}]", (Object)file.getAbsolutePath());
            try (FileInputStream inputStream = new FileInputStream(file);){
                properties.load(inputStream);
            }
        }
    }

    @Override
    public ConfigurableEnvironment setBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) {
        this.beanDefinitionRegistry = beanDefinitionRegistry;
        return this;
    }

    @Override
    public ConfigurableEnvironment setBeanDefinitionLoader(BeanDefinitionLoader beanDefinitionLoader) {
        this.beanDefinitionLoader = beanDefinitionLoader;
        return this;
    }

    @Override
    public boolean acceptsProfiles(String ... profiles) {
        for (String profile : profiles) {
            if (!(StringUtils.isNotEmpty(profile) && profile.charAt(0) == '!' ? !this.activeProfiles.contains(profile.substring(1)) : this.activeProfiles.contains(profile))) continue;
            return true;
        }
        return false;
    }

    @Override
    public ConfigurableEnvironment setBeanNameCreator(BeanNameCreator beanNameCreator) {
        this.beanNameCreator = beanNameCreator;
        return this;
    }

    @Override
    public BeanNameCreator getBeanNameCreator() {
        return this.beanNameCreator;
    }
}

