/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.env;

import cn.taketoday.context.BeanNameCreator;
import cn.taketoday.context.env.ConfigurableEnvironment;

public class DefaultBeanNameCreator
implements BeanNameCreator {
    private boolean useSimpleName = true;

    public DefaultBeanNameCreator(ConfigurableEnvironment environment) {
        String useSimpleName = environment.getProperty("context.name.simple");
        if (useSimpleName != null) {
            this.useSimpleName = Boolean.parseBoolean(useSimpleName);
        }
    }

    @Override
    public String create(Class<?> beanClass) {
        if (beanClass == null) {
            return "default";
        }
        if (this.useSimpleName) {
            String simpleName = beanClass.getSimpleName();
            return (simpleName.charAt(0) + "").toLowerCase() + simpleName.substring(1);
        }
        return beanClass.getName();
    }
}

