/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.bean;

import cn.taketoday.context.Scope;
import cn.taketoday.context.bean.BeanDefinition;
import cn.taketoday.context.bean.PropertyValue;
import cn.taketoday.context.exception.NoSuchPropertyException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class DefaultBeanDefinition
implements BeanDefinition {
    private String name;
    private Class<? extends Object> beanClass;
    private Scope scope = Scope.SINGLETON;
    private Method[] initMethods;
    private String[] destroyMethods;
    private PropertyValue[] propertyValues;
    private boolean initialized = false;
    private boolean factoryBean = false;
    private boolean Abstract = false;

    public DefaultBeanDefinition() {
    }

    public DefaultBeanDefinition(String name, Class<? extends Object> beanClass) {
        this.beanClass = beanClass;
        this.name = name;
    }

    public DefaultBeanDefinition(String name, Class<? extends Object> beanClass, Scope scope) {
        this.name = name;
        this.scope = scope;
        this.beanClass = beanClass;
    }

    @Override
    public PropertyValue getPropertyValue(String name) throws NoSuchPropertyException {
        for (PropertyValue propertyValue : this.propertyValues) {
            if (!propertyValue.getField().getName().equals(name)) continue;
            return propertyValue;
        }
        throw new NoSuchPropertyException("No such property named: [" + name + "]");
    }

    @Override
    public boolean isSingleton() {
        return this.scope == Scope.SINGLETON;
    }

    @Override
    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public Method[] getInitMethods() {
        return this.initMethods;
    }

    @Override
    public String[] getDestroyMethods() {
        return this.destroyMethods;
    }

    @Override
    public Scope getScope() {
        return this.scope;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isFactoryBean() {
        return this.factoryBean;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean isAbstract() {
        return this.Abstract;
    }

    @Override
    public PropertyValue[] getPropertyValues() {
        return this.propertyValues;
    }

    @Override
    public BeanDefinition setFactoryBean(boolean factoryBean) {
        this.factoryBean = factoryBean;
        return this;
    }

    @Override
    public BeanDefinition setInitialized(boolean initialized) {
        this.initialized = initialized;
        return this;
    }

    @Override
    public BeanDefinition setAbstract(boolean Abstract) {
        this.Abstract = Abstract;
        return this;
    }

    @Override
    public BeanDefinition setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public BeanDefinition setScope(Scope scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public BeanDefinition setBeanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
        return this;
    }

    @Override
    public BeanDefinition setInitMethods(Method[] initMethods) {
        this.initMethods = initMethods;
        return this;
    }

    @Override
    public BeanDefinition setDestroyMethods(String[] destroyMethods) {
        this.destroyMethods = destroyMethods;
        return this;
    }

    @Override
    public BeanDefinition setPropertyValues(PropertyValue[] propertyValues) {
        this.propertyValues = propertyValues;
        return this;
    }

    @Override
    public void addPropertyValue(PropertyValue ... propertyValues_) {
        if (this.propertyValues == null) {
            this.propertyValues = propertyValues_;
            return;
        }
        List<PropertyValue> asList = Arrays.asList(this.propertyValues);
        for (PropertyValue propertyValue : propertyValues_) {
            asList.add(propertyValue);
        }
        this.propertyValues = asList.toArray(new PropertyValue[0]);
    }

    @Override
    public void addPropertyValue(Collection<PropertyValue> propertyValues) {
        if (propertyValues.isEmpty()) {
            return;
        }
        if (this.propertyValues == null) {
            this.propertyValues = propertyValues.toArray(new PropertyValue[0]);
            return;
        }
        propertyValues.addAll(Arrays.asList(this.propertyValues));
        this.propertyValues = propertyValues.toArray(new PropertyValue[0]);
    }

    public String toString() {
        return "{\n\t\"name\":\"" + this.name + "\",\n\t\"beanClass\":\"" + this.beanClass + "\",\n\t\"scope\":\"" + (Object)((Object)this.scope) + "\",\n\t\"initMethods\":\"" + Arrays.toString(this.initMethods) + "\",\n\t\"destroyMethods\":\"" + Arrays.toString(this.destroyMethods) + "\",\n\t\"propertyValues\":\"" + Arrays.toString(this.propertyValues) + "\",\n\t\"initialized\":\"" + this.initialized + "\",\n\t\"factoryBean\":\"" + this.factoryBean + "\",\n\t\"Abstract\":\"" + this.Abstract + "\"\n}";
    }
}

