/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context;

import cn.taketoday.context.AbstractApplicationContext;
import cn.taketoday.context.AnnotationAttributes;
import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.BeanNameCreator;
import cn.taketoday.context.ConfigurableApplicationContext;
import cn.taketoday.context.Scope;
import cn.taketoday.context.annotation.Component;
import cn.taketoday.context.annotation.Configuration;
import cn.taketoday.context.annotation.MissingBean;
import cn.taketoday.context.annotation.Props;
import cn.taketoday.context.aware.ApplicationContextAware;
import cn.taketoday.context.aware.Aware;
import cn.taketoday.context.aware.BeanFactoryAware;
import cn.taketoday.context.aware.BeanNameAware;
import cn.taketoday.context.aware.EnvironmentAware;
import cn.taketoday.context.bean.BeanDefinition;
import cn.taketoday.context.bean.DefaultBeanDefinition;
import cn.taketoday.context.bean.PropertyValue;
import cn.taketoday.context.bean.StandardBeanDefinition;
import cn.taketoday.context.event.LoadingMissingBeanEvent;
import cn.taketoday.context.exception.BeanDefinitionStoreException;
import cn.taketoday.context.exception.ContextException;
import cn.taketoday.context.factory.AbstractBeanFactory;
import cn.taketoday.context.factory.ConfigurableBeanFactory;
import cn.taketoday.context.loader.BeanDefinitionLoader;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ContextUtils;
import cn.taketoday.context.utils.StringUtils;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class StandardApplicationContext
extends AbstractApplicationContext
implements ConfigurableApplicationContext {
    private final StandardBeanFactory beanFactory = new StandardBeanFactory();

    public StandardApplicationContext(Collection<Class<?>> classes) {
        this("");
        this.loadContext(classes);
    }

    public StandardApplicationContext(String propertiesLocation) {
        this();
        if (StringUtils.isNotEmpty(propertiesLocation)) {
            this.setPropertiesLocation(propertiesLocation);
        }
    }

    public StandardApplicationContext(String propertiesLocation, String ... locations) {
        this(propertiesLocation);
        this.loadContext(locations);
    }

    public StandardApplicationContext() {
    }

    @Override
    public AbstractBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    @Override
    protected void doLoadBeanDefinitions(AbstractBeanFactory beanFactory, Collection<Class<?>> beanClasses) {
        beanFactory.getBeanDefinitionLoader().loadBeanDefinitions(beanClasses);
        this.beanFactory.loadConfigurationBeans();
        this.beanFactory.loadMissingBean(beanClasses);
    }

    public class StandardBeanFactory
    extends AbstractBeanFactory
    implements ConfigurableBeanFactory {
        private final Collection<Method> missingMethods = new HashSet<Method>(32, 1.0f);
        private BeanDefinitionLoader beanDefinitionLoader;

        @Override
        protected void aware(Object bean, String name) {
            if (bean instanceof Aware) {
                if (bean instanceof BeanNameAware) {
                    ((BeanNameAware)bean).setBeanName(name);
                }
                if (bean instanceof ApplicationContextAware) {
                    ((ApplicationContextAware)bean).setApplicationContext(StandardApplicationContext.this);
                }
                if (bean instanceof BeanFactoryAware) {
                    ((BeanFactoryAware)bean).setBeanFactory(this);
                }
                if (bean instanceof EnvironmentAware) {
                    ((EnvironmentAware)bean).setEnvironment(StandardApplicationContext.this.getEnvironment());
                }
            }
        }

        @Override
        protected Object createBeanInstance(BeanDefinition beanDefinition) throws Throwable {
            if (beanDefinition instanceof StandardBeanDefinition) {
                StandardBeanDefinition standardBeanDefinition = (StandardBeanDefinition)beanDefinition;
                Method factoryMethod = standardBeanDefinition.getFactoryMethod();
                return factoryMethod.invoke(this.getDeclaringInstance(standardBeanDefinition.getDeclaringName()), ContextUtils.resolveParameter(factoryMethod, this));
            }
            return super.createBeanInstance(beanDefinition);
        }

        private Object getDeclaringInstance(String declaringName) throws Throwable {
            BeanDefinition beanDefinition = this.getBeanDefinition(declaringName);
            if (beanDefinition.isInitialized()) {
                return this.getSingleton(declaringName);
            }
            Object declaringSingleton = super.initializingBean(this.createBeanInstance(beanDefinition), declaringName, beanDefinition);
            if (beanDefinition.isSingleton()) {
                this.registerSingleton(declaringName, declaringSingleton);
                beanDefinition.setInitialized(true);
            }
            return declaringSingleton;
        }

        private void loadConfigurationBeans() {
            for (Map.Entry<String, BeanDefinition> entry : this.getBeanDefinitionsMap().entrySet()) {
                BeanDefinition beanDefinition = entry.getValue();
                Class<?> beanClass = beanDefinition.getBeanClass();
                if (!beanClass.isAnnotationPresent(Configuration.class)) continue;
                for (Method method : beanClass.getDeclaredMethods()) {
                    if (!ContextUtils.conditional(method, StandardApplicationContext.this)) continue;
                    Collection<AnnotationAttributes> components = ClassUtils.getAnnotationAttributes(method, Component.class);
                    if (components.isEmpty()) {
                        if (!method.isAnnotationPresent(MissingBean.class)) continue;
                        this.missingMethods.add(method);
                        continue;
                    }
                    this.doRegisterDefinition(method, components);
                }
            }
        }

        private void doRegisterDefinition(Method method, Collection<AnnotationAttributes> components) throws BeanDefinitionStoreException {
            AbstractBeanFactory beanFactory = StandardApplicationContext.this.getBeanFactory();
            Class<?> returnType = method.getReturnType();
            BeanNameCreator beanNameCreator = beanFactory.getBeanNameCreator();
            BeanDefinitionLoader beanDefinitionLoader = beanFactory.getBeanDefinitionLoader();
            String defaultBeanName = beanNameCreator.create(returnType);
            String declaringBeanName = beanNameCreator.create(method.getDeclaringClass());
            for (AnnotationAttributes component : components) {
                Scope scope = (Scope)((Object)component.getEnum("scope"));
                String[] initMethods = component.getStringArray("initMethods");
                String[] destroyMethods = component.getStringArray("destroyMethods");
                for (String name : ContextUtils.findNames(defaultBeanName, component.getStringArray("value"))) {
                    StandardBeanDefinition beanDefinition = new StandardBeanDefinition();
                    beanDefinition.setName(name);
                    beanDefinition.setScope(scope);
                    beanDefinition.setBeanClass(returnType);
                    beanDefinition.setDestroyMethods(destroyMethods);
                    beanDefinition.setInitMethods(ContextUtils.resolveInitMethod(returnType, initMethods));
                    beanDefinition.setPropertyValues(ContextUtils.resolvePropertyValue(returnType, (ApplicationContext)StandardApplicationContext.this));
                    beanDefinition.setDeclaringName(declaringBeanName).setFactoryMethod(method);
                    ContextUtils.resolveProps(beanDefinition, StandardApplicationContext.this.getEnvironment());
                    beanDefinitionLoader.register(name, beanDefinition);
                }
            }
        }

        private void loadMissingBean(Collection<Class<?>> beanClasses) {
            StandardApplicationContext.this.publishEvent(new LoadingMissingBeanEvent(StandardApplicationContext.this, beanClasses));
            BeanNameCreator beanNameCreator = this.getBeanNameCreator();
            BeanDefinitionLoader beanDefinitionLoader = this.getBeanDefinitionLoader();
            for (Class<?> beanClass : beanClasses) {
                MissingBean missingBean = beanClass.getAnnotation(MissingBean.class);
                if (!this.isMissedBean(missingBean, beanClass)) continue;
                this.registerMissingBean(beanDefinitionLoader, beanNameCreator, missingBean, beanClass, new DefaultBeanDefinition());
            }
            for (Method method : this.missingMethods) {
                List<PropertyValue> resolvedProps;
                Class<?> beanClass = method.getReturnType();
                MissingBean missingBean = method.getAnnotation(MissingBean.class);
                if (!this.isMissedBean(missingBean, beanClass)) continue;
                StandardBeanDefinition beanDefinition = new StandardBeanDefinition().setFactoryMethod(method).setDeclaringName(beanNameCreator.create(method.getDeclaringClass()));
                if (method.isAnnotationPresent(Props.class) && !(resolvedProps = ContextUtils.resolveProps(method, StandardApplicationContext.this.getEnvironment().getProperties())).isEmpty()) {
                    beanDefinition.addPropertyValue(resolvedProps);
                }
                this.registerMissingBean(beanDefinitionLoader, beanNameCreator, missingBean, beanClass, beanDefinition);
            }
            this.missingMethods.clear();
        }

        private boolean isMissedBean(MissingBean missingBean, Class<?> beanClass) {
            if (missingBean == null) {
                return false;
            }
            String beanName = missingBean.value();
            if (StringUtils.isNotEmpty(beanName) && this.containsBeanDefinition(beanName)) {
                return false;
            }
            Class<?> type = missingBean.type();
            return (type == Void.TYPE || !this.containsBeanDefinition(type, true)) && !this.containsBeanDefinition(beanClass);
        }

        void registerMissingBean(BeanDefinitionLoader beanDefinitionLoader, BeanNameCreator beanNameCreator, MissingBean missingBean, Class<?> beanClass, BeanDefinition beanDefinition) {
            String beanName = missingBean.value();
            if (StringUtils.isEmpty(beanName)) {
                beanName = beanNameCreator.create(beanClass);
            }
            beanDefinition.setName(beanName);
            beanDefinition.setBeanClass(beanClass).setScope(missingBean.scope()).setDestroyMethods(missingBean.destroyMethods()).setInitMethods(ContextUtils.resolveInitMethod(beanClass, missingBean.initMethods())).setPropertyValues(ContextUtils.resolvePropertyValue(beanClass, (ApplicationContext)StandardApplicationContext.this));
            ContextUtils.resolveProps(beanDefinition, StandardApplicationContext.this.getEnvironment());
            beanDefinitionLoader.register(beanName, beanDefinition);
        }

        @Override
        public BeanDefinitionLoader getBeanDefinitionLoader() {
            if (this.beanDefinitionLoader == null) {
                try {
                    StandardApplicationContext.this.prepareBeanFactory(new HashSet());
                }
                catch (Throwable e) {
                    throw new ContextException(e);
                }
            }
            return this.beanDefinitionLoader;
        }

        @Override
        public void setBeanDefinitionLoader(BeanDefinitionLoader beanDefinitionLoader) {
            this.beanDefinitionLoader = beanDefinitionLoader;
        }
    }
}

