/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class AnnotationAttributes
extends HashMap<String, Object> {
    private static final String UNKNOWN = "unknown";
    private final Class<? extends Annotation> annotationType;
    private final String displayName;

    public AnnotationAttributes() {
        this.annotationType = null;
        this.displayName = UNKNOWN;
    }

    public AnnotationAttributes(int initialCapacity) {
        super(initialCapacity, 1.0f);
        this.annotationType = null;
        this.displayName = UNKNOWN;
    }

    public AnnotationAttributes(Class<? extends Annotation> annotationType, int initialCapacity) {
        super(initialCapacity, 1.0f);
        Objects.requireNonNull(annotationType, "'annotationType' must not be null");
        this.annotationType = annotationType;
        this.displayName = annotationType.getName();
    }

    public AnnotationAttributes(Map<String, Object> map) {
        super(map);
        this.annotationType = null;
        this.displayName = UNKNOWN;
    }

    public AnnotationAttributes(AnnotationAttributes other) {
        super(other);
        this.annotationType = other.annotationType;
        this.displayName = other.displayName;
    }

    public AnnotationAttributes(Class<? extends Annotation> annotationType) {
        Objects.requireNonNull(annotationType, "'annotationType' must not be null");
        this.annotationType = annotationType;
        this.displayName = annotationType.getName();
    }

    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    public String getString(String attributeName) {
        return this.getAttribute(attributeName, String.class);
    }

    public String[] getStringArray(String attributeName) {
        return this.getAttribute(attributeName, String[].class);
    }

    public boolean getBoolean(String attributeName) {
        return this.getAttribute(attributeName, Boolean.class);
    }

    public <N extends Number> N getNumber(String attributeName) {
        return (N)this.getAttribute(attributeName, Number.class);
    }

    public <E extends Enum<?>> E getEnum(String attributeName) {
        return (E)this.getAttribute(attributeName, Enum.class);
    }

    public <A extends Annotation> A[] getAnnotationArray(String attributeName, Class<A> annotationType) {
        return (Annotation[])this.getAttribute(attributeName, Array.newInstance(annotationType, 0).getClass());
    }

    public <T> T getAttribute(String attributeName, Class<T> expectedType) {
        Objects.requireNonNull(attributeName, "'attributeName' must not be null or empty");
        Object value = this.get(attributeName);
        this.assertAttributePresence(attributeName, value);
        if (!expectedType.isInstance(value) && expectedType.isArray() && expectedType.getComponentType().isInstance(value)) {
            Object array = Array.newInstance(expectedType.getComponentType(), 1);
            Array.set(array, 0, value);
            value = array;
        }
        this.assertAttributeType(attributeName, value, expectedType);
        return expectedType.cast(value);
    }

    private void assertAttributePresence(String attributeName, Object attributeValue) {
        Objects.requireNonNull(attributeValue, String.format("Attribute '%s' not found in attributes for annotation [%s]", attributeName, this.displayName));
    }

    private void assertAttributeType(String attributeName, Object attributeValue, Class<?> expectedType) {
        if (!expectedType.isInstance(attributeValue)) {
            throw new IllegalArgumentException(String.format("Attribute '%s' is of type [%s], but [%s] was expected in attributes for annotation [%s]", attributeName, attributeValue.getClass().getName(), expectedType.getName(), this.displayName));
        }
    }

    @Override
    public Object putIfAbsent(String key, Object value) {
        Object obj = this.get(key);
        if (obj == null) {
            obj = this.put(key, value);
        }
        return obj;
    }

    @Override
    public String toString() {
        Iterator entries = this.entrySet().iterator();
        StringBuilder sb = new StringBuilder("{");
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            sb.append((String)entry.getKey());
            sb.append('=');
            sb.append(this.valueToString(entry.getValue()));
            sb.append(entries.hasNext() ? ", " : "");
        }
        sb.append("}");
        return sb.toString();
    }

    private String valueToString(Object value) {
        if (value == this) {
            return "(this Map)";
        }
        if (value instanceof Object[]) {
            return Arrays.toString((Object[])value);
        }
        return String.valueOf(value);
    }

    public static AnnotationAttributes fromMap(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        if (map instanceof AnnotationAttributes) {
            return (AnnotationAttributes)map;
        }
        return new AnnotationAttributes(map);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AnnotationAttributes)) {
            return false;
        }
        AnnotationAttributes other = (AnnotationAttributes)object;
        if (other.annotationType != this.annotationType || !this.displayName.equals(other.displayName)) {
            return false;
        }
        return super.equals(object);
    }
}

