/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context;

import cn.taketoday.context.BeanNameCreator;
import cn.taketoday.context.ConfigurableApplicationContext;
import cn.taketoday.context.annotation.ContextListener;
import cn.taketoday.context.bean.BeanDefinition;
import cn.taketoday.context.env.ConfigurableEnvironment;
import cn.taketoday.context.env.DefaultBeanNameCreator;
import cn.taketoday.context.env.Environment;
import cn.taketoday.context.env.StandardEnvironment;
import cn.taketoday.context.event.BeanDefinitionLoadedEvent;
import cn.taketoday.context.event.BeanDefinitionLoadingEvent;
import cn.taketoday.context.event.ContextCloseEvent;
import cn.taketoday.context.event.ContextRefreshEvent;
import cn.taketoday.context.event.ContextStartedEvent;
import cn.taketoday.context.event.HandleDependencyEvent;
import cn.taketoday.context.event.ObjectRefreshedEvent;
import cn.taketoday.context.exception.BeanDefinitionStoreException;
import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.exception.ContextException;
import cn.taketoday.context.factory.AbstractBeanFactory;
import cn.taketoday.context.factory.BeanPostProcessor;
import cn.taketoday.context.listener.ApplicationListener;
import cn.taketoday.context.loader.BeanDefinitionLoader;
import cn.taketoday.context.loader.DefaultBeanDefinitionLoader;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ExceptionUtils;
import cn.taketoday.context.utils.OrderUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractApplicationContext
implements ConfigurableApplicationContext {
    private static final Logger log = LoggerFactory.getLogger(AbstractApplicationContext.class);
    private final long startupDate;
    private String propertiesLocation = "";
    private BeanNameCreator beanNameCreator;
    private ConfigurableEnvironment environment;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final Map<Class<?>, List<ApplicationListener<EventObject>>> applicationListeners = new HashMap(10, 1.0f);

    public AbstractApplicationContext() {
        this.startupDate = System.currentTimeMillis();
        log.info("Starting Application Context at [{}].", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(this.startupDate)));
    }

    public void loadContext() {
        this.loadContext("");
    }

    @Override
    public void loadContext(String ... locations) {
        this.loadContext(ClassUtils.scan(locations));
    }

    @Override
    public void loadContext(Collection<Class<?>> classes) {
        try {
            this.prepareRefresh();
            this.prepareBeanFactory(classes);
            this.onRefresh();
            this.refresh();
            this.finishRefresh();
        }
        catch (Throwable ex) {
            ex = ExceptionUtils.unwrapThrowable(ex);
            log.error("An Exception Occurred When Loading Context, With Msg: [{}]", (Object)ex.getMessage(), (Object)ex);
        }
    }

    protected void prepareRefresh() {
        try {
            this.getEnvironment().loadProperties(this.propertiesLocation);
        }
        catch (IOException ex) {
            log.error("An Exception Occurred When Loading Properties, With Msg: [{}]", (Object)ex.getMessage(), (Object)ex);
        }
    }

    protected abstract void doLoadBeanDefinitions(AbstractBeanFactory var1, Collection<Class<?>> var2);

    private void finishRefresh() {
        ClassUtils.clearCache();
        this.publishEvent(new ContextStartedEvent(this));
        this.started.set(true);
    }

    protected void onRefresh() throws ContextException {
    }

    public void prepareBeanFactory(Collection<Class<?>> classes) {
        AbstractBeanFactory beanFactory = this.getBeanFactory();
        this.postProcessBeanFactory(beanFactory);
        ConfigurableEnvironment environment = this.getEnvironment();
        BeanNameCreator beanNameCreator = environment.getBeanNameCreator();
        if (beanNameCreator == null) {
            beanNameCreator = new DefaultBeanNameCreator(environment);
            environment.setBeanNameCreator(beanNameCreator);
        }
        if (environment.getBeanDefinitionRegistry() == null) {
            environment.setBeanDefinitionRegistry(this);
        }
        beanFactory.setBeanNameCreator(beanNameCreator);
        BeanDefinitionLoader beanDefinitionLoader = environment.getBeanDefinitionLoader();
        if (beanDefinitionLoader == null) {
            beanDefinitionLoader = new DefaultBeanDefinitionLoader(this);
            environment.setBeanDefinitionLoader(beanDefinitionLoader);
        }
        beanFactory.setBeanDefinitionLoader(beanDefinitionLoader);
        this.registerSingleton(beanNameCreator.create(Environment.class), environment);
        this.registerListener();
        this.publishEvent(new BeanDefinitionLoadingEvent(this));
        this.doLoadBeanDefinitions(beanFactory, classes);
        this.publishEvent(new BeanDefinitionLoadedEvent(this));
        this.publishEvent(new HandleDependencyEvent(this));
        beanFactory.handleDependency();
        beanFactory.registerBeanPostProcessors();
    }

    protected void postProcessBeanFactory(AbstractBeanFactory beanFactory) {
    }

    void registerListener() {
        log.debug("Loading Application Listeners.");
        for (Class<?> clazz : ClassUtils.getImplClasses(ApplicationListener.class)) {
            this.forEach(clazz);
        }
        for (Map.Entry entry : this.applicationListeners.entrySet()) {
            OrderUtils.reversedSort((List)entry.getValue());
        }
    }

    private void forEach(Class<?> listenerClass) {
        try {
            ContextListener contextListener = listenerClass.getAnnotation(ContextListener.class);
            if (contextListener == null) {
                return;
            }
            if (!ApplicationListener.class.isAssignableFrom(listenerClass)) {
                throw new ConfigurationException("[{}] must be a [{}]", listenerClass.getName(), ApplicationListener.class.getClass().getName());
            }
            String name = this.getBeanNameCreator().create(listenerClass);
            Object applicationListener = this.getSingleton(name);
            if (applicationListener == null) {
                applicationListener = ClassUtils.newInstance(listenerClass);
                this.registerSingleton(name, applicationListener);
            }
            for (Method method : listenerClass.getDeclaredMethods()) {
                if (!method.getName().equals("onApplicationEvent") || method.isBridge()) continue;
                AbstractApplicationContext.doRegisterListener(this.applicationListeners, applicationListener, method.getParameterTypes()[0]);
            }
        }
        catch (Throwable ex) {
            ex = ExceptionUtils.unwrapThrowable(ex);
            log.error("An Exception Occurred When Register Application Listener, With Msg: [{}]", (Object)ex.getMessage(), (Object)ex);
        }
    }

    static void doRegisterListener(Map<Class<?>, List<ApplicationListener<EventObject>>> applicationListeners, final Object applicationListener, Class<?> eventType) {
        if (applicationListeners.containsKey(eventType)) {
            applicationListeners.get(eventType).add((ApplicationListener)applicationListener);
            return;
        }
        applicationListeners.put(eventType, (List<ApplicationListener<EventObject>>)new ArrayList<ApplicationListener<EventObject>>(){
            {
                this.add((ApplicationListener)applicationListener);
            }
        });
    }

    @Override
    public void refresh() throws ContextException {
        try {
            this.publishEvent(new ContextRefreshEvent(this));
            this.getBeanFactory().preInitializeSingletons();
        }
        catch (Throwable ex) {
            ex = ExceptionUtils.unwrapThrowable(ex);
            log.error("An Exception Occurred When Refresh Context: [{}] With Msg: [{}]", new Object[]{this, ex.getMessage(), ex});
            throw new ContextException(ex);
        }
    }

    @Override
    public void close() {
        this.started.set(false);
        this.publishEvent(new ContextCloseEvent(this));
    }

    @Override
    public void publishEvent(EventObject event) {
        List<ApplicationListener<EventObject>> listeners;
        if (log.isDebugEnabled()) {
            log.debug("Publish event: [{}]", (Object)event.getClass().getName());
        }
        if ((listeners = this.applicationListeners.get(event.getClass())) == null || listeners.isEmpty()) {
            return;
        }
        for (ApplicationListener<EventObject> applicationListener : listeners) {
            applicationListener.onApplicationEvent(event);
        }
    }

    @Override
    public abstract AbstractBeanFactory getBeanFactory();

    @Override
    public void setEnvironment(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    public BeanNameCreator getBeanNameCreator() {
        if (this.beanNameCreator == null) {
            this.beanNameCreator = this.createBeanNameCreator();
        }
        return this.beanNameCreator;
    }

    @Override
    public ConfigurableEnvironment getEnvironment() {
        if (this.environment == null) {
            this.environment = this.createEnvironment();
        }
        return this.environment;
    }

    protected BeanNameCreator createBeanNameCreator() {
        return new DefaultBeanNameCreator(this.getEnvironment());
    }

    protected ConfigurableEnvironment createEnvironment() {
        return new StandardEnvironment();
    }

    @Override
    public boolean hasStarted() {
        return this.started.get();
    }

    @Override
    public long getStartupDate() {
        return this.startupDate;
    }

    @Override
    public void registerBean(String name, BeanDefinition beanDefinition) throws BeanDefinitionStoreException {
        this.getBeanFactory().registerBean(name, beanDefinition);
    }

    @Override
    public void removeBean(String name) throws BeanDefinitionStoreException {
        this.getBeanFactory().removeBean(name);
    }

    @Override
    public void registerBean(String name, Class<?> clazz) throws BeanDefinitionStoreException {
        this.getBeanFactory().registerBean(name, clazz);
    }

    @Override
    public void registerBean(Class<?> clazz) throws BeanDefinitionStoreException, ConfigurationException {
        this.getBeanFactory().registerBean(clazz);
    }

    @Override
    public void registerBean(Set<Class<?>> clazz) throws BeanDefinitionStoreException {
        this.getBeanFactory().registerBean(clazz);
    }

    @Override
    public void destroyBean(String name) {
        this.getBeanFactory().destroyBean(name);
    }

    @Override
    public void refresh(String name) {
        try {
            this.getBeanFactory().refresh(name);
            this.publishEvent(new ObjectRefreshedEvent(this.getBeanDefinition(name), this));
        }
        catch (Throwable ex) {
            ex = ExceptionUtils.unwrapThrowable(ex);
            log.error("Can't refresh a bean named: [{}], With Msg: [{}]", new Object[]{name, ex.getMessage(), ex});
            throw new ContextException(ex);
        }
    }

    @Override
    public Object refresh(BeanDefinition beanDefinition) {
        try {
            Object initializingBean = this.getBeanFactory().refresh(beanDefinition);
            this.publishEvent(new ObjectRefreshedEvent(beanDefinition, this));
            return initializingBean;
        }
        catch (Throwable ex) {
            ex = ExceptionUtils.unwrapThrowable(ex);
            log.error("Can't refresh a bean named: [{}], With Msg: [{}]", new Object[]{beanDefinition.getName(), ex.getMessage(), ex});
            throw new ContextException(ex);
        }
    }

    @Override
    public void preInitializeSingletons() throws Throwable {
        this.getBeanFactory().preInitializeSingletons();
    }

    @Override
    public void addBeanPostProcessor(BeanPostProcessor beanPostProcessor) {
        this.getBeanFactory().addBeanPostProcessor(beanPostProcessor);
    }

    @Override
    public void removeBeanPostProcessor(BeanPostProcessor beanPostProcessor) {
        this.getBeanFactory().removeBeanPostProcessor(beanPostProcessor);
    }

    @Override
    public Object getBean(String name) {
        return this.getBeanFactory().getBean(name);
    }

    @Override
    public <T> T getBean(Class<T> requiredType) {
        return this.getBeanFactory().getBean(requiredType);
    }

    @Override
    public <T> T getBean(String name, Class<T> requiredType) {
        return this.getBeanFactory().getBean(name, requiredType);
    }

    @Override
    public <T> List<T> getBeans(Class<T> requiredType) {
        return this.getBeanFactory().getBeans(requiredType);
    }

    @Override
    public boolean isSingleton(String name) {
        return this.getBeanFactory().isSingleton(name);
    }

    @Override
    public boolean isPrototype(String name) {
        return this.getBeanFactory().isPrototype(name);
    }

    @Override
    public Class<?> getType(String name) {
        return this.getBeanFactory().getType(name);
    }

    @Override
    public Set<String> getAliases(Class<?> type) {
        return this.getBeanFactory().getAliases(type);
    }

    @Override
    public String getBeanName(Class<?> targetClass) {
        return this.getBeanFactory().getBeanName(targetClass);
    }

    @Override
    public void registerSingleton(String name, Object bean) {
        this.getBeanFactory().registerSingleton(name, bean);
    }

    @Override
    public void registerSingleton(Object bean) {
        this.getBeanFactory().registerSingleton(bean);
    }

    @Override
    public Map<String, Object> getSingletonsMap() {
        return this.getBeanFactory().getSingletonsMap();
    }

    @Override
    public Object getSingleton(String name) {
        return this.getBeanFactory().getSingleton(name);
    }

    @Override
    public void removeSingleton(String name) {
        this.getBeanFactory().removeSingleton(name);
    }

    @Override
    public boolean containsSingleton(String name) {
        return this.getBeanFactory().containsSingleton(name);
    }

    @Override
    public Map<String, BeanDefinition> getBeanDefinitionsMap() {
        return this.getBeanFactory().getBeanDefinitionsMap();
    }

    @Override
    public void registerBeanDefinition(String name, BeanDefinition beanDefinition) {
        this.getBeanFactory().registerBeanDefinition(name, beanDefinition);
    }

    @Override
    public void removeBeanDefinition(String beanName) {
        this.getBeanFactory().removeBeanDefinition(beanName);
    }

    @Override
    public BeanDefinition getBeanDefinition(String beanName) {
        return this.getBeanFactory().getBeanDefinition(beanName);
    }

    @Override
    public BeanDefinition getBeanDefinition(Class<?> beanClass) {
        return this.getBeanFactory().getBeanDefinition(beanClass);
    }

    @Override
    public boolean containsBeanDefinition(String beanName) {
        return this.getBeanFactory().containsBeanDefinition(beanName);
    }

    @Override
    public boolean containsBeanDefinition(Class<?> type) {
        return this.getBeanFactory().containsBeanDefinition(type);
    }

    @Override
    public boolean containsBeanDefinition(Class<?> type, boolean equals) {
        return this.getBeanFactory().containsBeanDefinition(type, equals);
    }

    @Override
    public Set<String> getBeanDefinitionNames() {
        return this.getBeanFactory().getBeanDefinitionNames();
    }

    @Override
    public int getBeanDefinitionCount() {
        return this.getBeanFactory().getBeanDefinitionCount();
    }

    public void setPropertiesLocation(String propertiesLocation) {
        this.propertiesLocation = propertiesLocation;
    }
}

