/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.target;

import cn.taketoday.aop.IntroductionAdvisor;
import cn.taketoday.aop.support.DefaultIntroductionAdvisor;
import cn.taketoday.aop.support.DelegatingIntroductionInterceptor;
import cn.taketoday.aop.target.AbstractPrototypeTargetSource;
import cn.taketoday.aop.target.ThreadLocalTargetSourceStats;
import cn.taketoday.beans.factory.DisposableBean;
import cn.taketoday.core.NamedThreadLocal;
import java.util.HashSet;
import java.util.Set;

public class ThreadLocalTargetSource
extends AbstractPrototypeTargetSource
implements ThreadLocalTargetSourceStats,
DisposableBean {
    private static final long serialVersionUID = 1L;
    private final ThreadLocal<Object> targetInThread = new NamedThreadLocal("Thread-local instance of bean '" + this.getTargetBeanName() + "'");
    private final Set<Object> targetSet = new HashSet<Object>();
    private int invocationCount;
    private int hitCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getTarget() {
        ++this.invocationCount;
        Object target = this.targetInThread.get();
        if (target == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No target for prototype '{}' bound to thread: creating one and binding it to thread '{}'", (Object)this.getTargetBeanName(), (Object)Thread.currentThread().getName());
            }
            target = this.newPrototypeInstance();
            this.targetInThread.set(target);
            Set<Object> set = this.targetSet;
            synchronized (set) {
                this.targetSet.add(target);
            }
        } else {
            ++this.hitCount;
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.logger.debug("Destroying ThreadLocalTargetSource bindings");
        Set<Object> set = this.targetSet;
        synchronized (set) {
            for (Object target : this.targetSet) {
                this.destroyPrototypeInstance(target);
            }
            this.targetSet.clear();
        }
        this.targetInThread.remove();
    }

    @Override
    public int getInvocationCount() {
        return this.invocationCount;
    }

    @Override
    public int getHitCount() {
        return this.hitCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getObjectCount() {
        Set<Object> set = this.targetSet;
        synchronized (set) {
            return this.targetSet.size();
        }
    }

    public IntroductionAdvisor getStatsMixin() {
        DelegatingIntroductionInterceptor dii = new DelegatingIntroductionInterceptor(this);
        return new DefaultIntroductionAdvisor(dii, ThreadLocalTargetSourceStats.class);
    }
}

