/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.target;

import cn.taketoday.aop.target.AbstractRefreshableTargetSource;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.lang.Assert;

public class BeanFactoryRefreshableTargetSource
extends AbstractRefreshableTargetSource {
    private final String beanName;
    private final BeanFactory beanFactory;

    public BeanFactoryRefreshableTargetSource(BeanFactory beanFactory, String beanName) {
        Assert.notNull((Object)beanName, (String)"Bean name is required");
        Assert.notNull((Object)beanFactory, (String)"BeanFactory is required");
        this.beanName = beanName;
        this.beanFactory = beanFactory;
    }

    @Override
    protected final Object freshTarget() {
        return this.obtainFreshBean(this.beanFactory, this.beanName);
    }

    protected Object obtainFreshBean(BeanFactory beanFactory, String beanName) {
        return beanFactory.getBean(beanName);
    }
}

