/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.target;

import cn.taketoday.aop.support.DefaultIntroductionAdvisor;
import cn.taketoday.aop.support.DelegatingIntroductionInterceptor;
import cn.taketoday.aop.target.AbstractPrototypeTargetSource;
import cn.taketoday.aop.target.PoolingConfig;
import cn.taketoday.beans.BeansException;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanInitializationException;
import cn.taketoday.beans.factory.DisposableBean;
import cn.taketoday.lang.Nullable;

public abstract class AbstractPoolingTargetSource
extends AbstractPrototypeTargetSource
implements PoolingConfig,
DisposableBean {
    private int maxSize = -1;

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public final void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        super.setBeanFactory(beanFactory);
        try {
            this.createPool();
        }
        catch (Throwable ex) {
            throw new BeanInitializationException("Could not create instance pool for TargetSource", ex);
        }
    }

    protected abstract void createPool() throws Exception;

    @Override
    @Nullable
    public abstract Object getTarget() throws Exception;

    @Override
    public abstract void releaseTarget(Object var1) throws Exception;

    public DefaultIntroductionAdvisor getPoolingConfigMixin() {
        DelegatingIntroductionInterceptor dii = new DelegatingIntroductionInterceptor(this);
        return new DefaultIntroductionAdvisor(dii, PoolingConfig.class);
    }
}

