/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.target;

import cn.taketoday.aop.TargetSource;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;

public abstract class AbstractLazyCreationTargetSource
implements TargetSource {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Object lazyTarget;

    public synchronized boolean isInitialized() {
        return this.lazyTarget != null;
    }

    @Override
    public synchronized Class<?> getTargetClass() {
        return this.lazyTarget != null ? this.lazyTarget.getClass() : null;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public synchronized Object getTarget() throws Exception {
        if (this.lazyTarget == null) {
            this.logger.debug("Initializing lazy target object");
            this.lazyTarget = this.createObject();
        }
        return this.lazyTarget;
    }

    protected abstract Object createObject() throws Exception;
}

