/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.target;

import cn.taketoday.aop.TargetSource;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryAware;
import cn.taketoday.beans.factory.NoSuchBeanDefinitionException;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import java.io.Serializable;
import java.util.Objects;

public abstract class AbstractBeanFactoryTargetSource
implements TargetSource,
BeanFactoryAware,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private String targetBeanName;
    private volatile Class<?> targetClass;
    private BeanFactory beanFactory;

    public void setTargetBeanName(String targetBeanName) {
        this.targetBeanName = targetBeanName;
    }

    public String getTargetBeanName() {
        return this.targetBeanName;
    }

    public void setTargetClass(Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (this.targetBeanName == null) {
            throw new IllegalStateException("Property 'targetBeanName' is required");
        }
        this.beanFactory = beanFactory;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> getTargetClass() {
        Class<?> targetClass = this.targetClass;
        if (targetClass != null) {
            return targetClass;
        }
        AbstractBeanFactoryTargetSource abstractBeanFactoryTargetSource = this;
        synchronized (abstractBeanFactoryTargetSource) {
            targetClass = this.targetClass;
            if (targetClass == null && this.beanFactory != null) {
                targetClass = this.beanFactory.getType(this.targetBeanName);
                if (targetClass == null) {
                    Object beanInstance;
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("Getting bean with name '{}' for type determination", (Object)this.targetBeanName);
                    }
                    if ((beanInstance = this.beanFactory.getBean(this.targetBeanName)) == null) {
                        throw new NoSuchBeanDefinitionException(this.targetBeanName);
                    }
                    targetClass = beanInstance.getClass();
                }
                this.targetClass = targetClass;
            }
            return targetClass;
        }
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public void releaseTarget(Object target) throws Exception {
    }

    protected void copyFrom(AbstractBeanFactoryTargetSource other) {
        this.targetClass = other.targetClass;
        this.beanFactory = other.beanFactory;
        this.targetBeanName = other.targetBeanName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AbstractBeanFactoryTargetSource otherTarget = (AbstractBeanFactoryTargetSource)other;
        return Objects.equals(this.beanFactory, otherTarget.beanFactory) && Objects.equals(this.targetBeanName, otherTarget.targetBeanName);
    }

    public int hashCode() {
        int hashCode = this.getClass().hashCode();
        hashCode = 13 * hashCode + Objects.hashCode(this.beanFactory);
        hashCode = 13 * hashCode + Objects.hashCode(this.targetBeanName);
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(" for target bean '").append(this.targetBeanName).append("'");
        if (this.targetClass != null) {
            sb.append(" of type [").append(this.targetClass.getName()).append("]");
        }
        return sb.toString();
    }
}

