/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.support.annotation;

import cn.taketoday.aop.ClassFilter;
import cn.taketoday.core.annotation.AnnotatedElementUtils;
import cn.taketoday.lang.Assert;
import java.lang.annotation.Annotation;

public class AnnotationClassFilter
implements ClassFilter {
    private final boolean checkInherited;
    private final Class<? extends Annotation> annotationType;

    public AnnotationClassFilter(Class<? extends Annotation> annotationType) {
        this(annotationType, false);
    }

    public AnnotationClassFilter(Class<? extends Annotation> annotationType, boolean checkInherited) {
        Assert.notNull(annotationType, (String)"Annotation type must not be null");
        this.annotationType = annotationType;
        this.checkInherited = checkInherited;
    }

    @Override
    public boolean matches(Class<?> clazz) {
        return this.checkInherited ? AnnotatedElementUtils.hasAnnotation(clazz, this.annotationType) : clazz.isAnnotationPresent(this.annotationType);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnnotationClassFilter)) {
            return false;
        }
        AnnotationClassFilter otherCf = (AnnotationClassFilter)other;
        return this.checkInherited == otherCf.checkInherited && this.annotationType.equals(otherCf.annotationType);
    }

    public int hashCode() {
        return this.annotationType.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.annotationType;
    }
}

