/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.support;

import cn.taketoday.aop.support.StaticMethodMatcherPointcut;
import cn.taketoday.core.ArraySizeTrimmer;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.StringUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class NameMatchMethodPointcut
extends StaticMethodMatcherPointcut
implements Serializable,
ArraySizeTrimmer {
    private final ArrayList<String> mappedNames = new ArrayList();

    public void setMappedName(@Nullable String mappedName) {
        this.setMappedNames(mappedName);
    }

    public void setMappedNames(String ... mappedNames) {
        this.mappedNames.clear();
        CollectionUtils.addAll(this.mappedNames, (Object[])mappedNames);
        this.trimToSize();
    }

    public NameMatchMethodPointcut addMethodName(String name) {
        this.mappedNames.add(name);
        return this;
    }

    @Override
    public boolean matches(Method method, Class<?> targetClass) {
        String methodName = method.getName();
        for (String mappedName : this.mappedNames) {
            if (!mappedName.equals(methodName) && !this.isMatch(methodName, mappedName)) continue;
            return true;
        }
        return false;
    }

    protected boolean isMatch(String methodName, String mappedName) {
        return StringUtils.simpleMatch((String)mappedName, (String)methodName);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof NameMatchMethodPointcut && this.mappedNames.equals(((NameMatchMethodPointcut)other).mappedNames);
    }

    public int hashCode() {
        return this.mappedNames.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.mappedNames;
    }

    public void trimToSize() {
        this.mappedNames.trimToSize();
    }
}

