/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.support;

import cn.taketoday.aop.IntroductionInfo;
import cn.taketoday.util.ClassUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.intercept.MethodInvocation;

public class IntroductionInfoSupport
implements IntroductionInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    final LinkedHashSet<Class<?>> publishedInterfaces = new LinkedHashSet();
    private transient ConcurrentHashMap<Method, Boolean> rememberedMethods = new ConcurrentHashMap(32);

    public void suppressInterface(Class<?> ifc) {
        this.publishedInterfaces.remove(ifc);
    }

    @Override
    public Class<?>[] getInterfaces() {
        return ClassUtils.toClassArray(this.publishedInterfaces);
    }

    public boolean implementsInterface(Class<?> ifc) {
        for (Class clazz : this.publishedInterfaces) {
            if (!ifc.isInterface() || !ifc.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    protected void implementInterfacesOnObject(Object delegate) {
        this.publishedInterfaces.addAll(ClassUtils.getAllInterfacesAsSet((Object)delegate));
    }

    protected final boolean isMethodOnIntroducedInterface(MethodInvocation mi) {
        Boolean rememberedResult = this.rememberedMethods.get(mi.getMethod());
        if (rememberedResult != null) {
            return rememberedResult;
        }
        boolean result = this.implementsInterface(mi.getMethod().getDeclaringClass());
        this.rememberedMethods.put(mi.getMethod(), result);
        return result;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.rememberedMethods = new ConcurrentHashMap(32);
    }
}

