/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.support;

import cn.taketoday.aop.DynamicIntroductionAdvice;
import cn.taketoday.aop.IntroductionInterceptor;
import cn.taketoday.aop.framework.AbstractMethodInvocation;
import cn.taketoday.aop.support.AopUtils;
import cn.taketoday.aop.support.IntroductionInfoSupport;
import cn.taketoday.util.ReflectionUtils;
import java.util.WeakHashMap;
import org.aopalliance.intercept.MethodInvocation;

public class DelegatePerTargetObjectIntroductionInterceptor
extends IntroductionInfoSupport
implements IntroductionInterceptor {
    private static final long serialVersionUID = 1L;
    private final WeakHashMap<Object, Object> delegateMap = new WeakHashMap();
    private final Class<?> interfaceType;
    private final Class<?> defaultImplType;

    public DelegatePerTargetObjectIntroductionInterceptor(Class<?> defaultImplType, Class<?> interfaceType) {
        this.interfaceType = interfaceType;
        this.defaultImplType = defaultImplType;
        Object delegate = this.createNewDelegate();
        this.implementInterfacesOnObject(delegate);
        this.suppressInterface(IntroductionInterceptor.class);
        this.suppressInterface(DynamicIntroductionAdvice.class);
    }

    @Override
    public Object invoke(MethodInvocation mi) throws Throwable {
        if (this.isMethodOnIntroducedInterface(mi)) {
            Object delegate = this.getIntroductionDelegateFor(mi.getThis());
            Object retVal = AopUtils.invokeJoinpointUsingReflection(delegate, mi.getMethod(), mi.getArguments());
            if (retVal == delegate && mi instanceof AbstractMethodInvocation) {
                retVal = ((AbstractMethodInvocation)mi).getProxy();
            }
            return retVal;
        }
        return this.doProceed(mi);
    }

    protected Object doProceed(MethodInvocation mi) throws Throwable {
        return mi.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getIntroductionDelegateFor(Object targetObject) {
        WeakHashMap<Object, Object> weakHashMap = this.delegateMap;
        synchronized (weakHashMap) {
            if (this.delegateMap.containsKey(targetObject)) {
                return this.delegateMap.get(targetObject);
            }
            Object delegate = this.createNewDelegate();
            this.delegateMap.put(targetObject, delegate);
            return delegate;
        }
    }

    private Object createNewDelegate() {
        try {
            return ReflectionUtils.accessibleConstructor(this.defaultImplType, (Class[])new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Cannot create default implementation for '" + this.interfaceType.getName() + "' mixin (" + this.defaultImplType.getName() + "): " + ex);
        }
    }
}

