/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.scope;

import cn.taketoday.aop.framework.autoproxy.AutoProxyUtils;
import cn.taketoday.aop.scope.ScopedProxyFactoryBean;
import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.config.BeanDefinitionHolder;
import cn.taketoday.beans.factory.support.AbstractBeanDefinition;
import cn.taketoday.beans.factory.support.BeanDefinitionRegistry;
import cn.taketoday.beans.factory.support.RootBeanDefinition;
import cn.taketoday.lang.Nullable;

public abstract class ScopedProxyUtils {
    private static final String TARGET_NAME_PREFIX = "scopedTarget.";
    private static final int TARGET_NAME_PREFIX_LENGTH = "scopedTarget.".length();

    public static BeanDefinitionHolder createScopedProxy(BeanDefinitionHolder definition, BeanDefinitionRegistry registry, boolean proxyTargetClass) {
        String originalBeanName = definition.getBeanName();
        BeanDefinition targetDefinition = definition.getBeanDefinition();
        String targetBeanName = ScopedProxyUtils.getTargetBeanName(originalBeanName);
        RootBeanDefinition proxyDefinition = new RootBeanDefinition(ScopedProxyFactoryBean.class);
        proxyDefinition.setDecoratedDefinition(new BeanDefinitionHolder(targetDefinition, targetBeanName));
        proxyDefinition.setOriginatingBeanDefinition(targetDefinition);
        proxyDefinition.setSource(definition.getSource());
        proxyDefinition.setRole(targetDefinition.getRole());
        proxyDefinition.getPropertyValues().add("targetBeanName", (Object)targetBeanName);
        if (proxyTargetClass) {
            targetDefinition.setAttribute(AutoProxyUtils.PRESERVE_TARGET_CLASS_ATTRIBUTE, (Object)Boolean.TRUE);
        } else {
            proxyDefinition.getPropertyValues().add("proxyTargetClass", (Object)Boolean.FALSE);
        }
        proxyDefinition.setAutowireCandidate(targetDefinition.isAutowireCandidate());
        proxyDefinition.setPrimary(targetDefinition.isPrimary());
        if (targetDefinition instanceof AbstractBeanDefinition) {
            proxyDefinition.copyQualifiersFrom((AbstractBeanDefinition)targetDefinition);
        }
        targetDefinition.setAutowireCandidate(false);
        targetDefinition.setPrimary(false);
        registry.registerBeanDefinition(targetBeanName, targetDefinition);
        return new BeanDefinitionHolder((BeanDefinition)proxyDefinition, originalBeanName, definition.getAliases());
    }

    public static String getTargetBeanName(String originalBeanName) {
        return TARGET_NAME_PREFIX + originalBeanName;
    }

    public static String getOriginalBeanName(@Nullable String targetBeanName) {
        if (ScopedProxyUtils.isScopedTarget(targetBeanName)) {
            return targetBeanName.substring(TARGET_NAME_PREFIX_LENGTH);
        }
        throw new IllegalArgumentException("bean name '" + targetBeanName + "' does not refer to the target of a scoped proxy");
    }

    public static boolean isScopedTarget(@Nullable String beanName) {
        return beanName != null && beanName.startsWith(TARGET_NAME_PREFIX);
    }
}

