/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.scope;

import cn.taketoday.aop.scope.ScopedProxyFactoryBean;
import cn.taketoday.aot.generate.GeneratedMethod;
import cn.taketoday.aot.generate.GenerationContext;
import cn.taketoday.beans.factory.aot.BeanRegistrationAotContribution;
import cn.taketoday.beans.factory.aot.BeanRegistrationAotProcessor;
import cn.taketoday.beans.factory.aot.BeanRegistrationCode;
import cn.taketoday.beans.factory.aot.BeanRegistrationCodeFragments;
import cn.taketoday.beans.factory.aot.BeanRegistrationCodeFragmentsDecorator;
import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.beans.factory.support.InstanceSupplier;
import cn.taketoday.beans.factory.support.RegisteredBean;
import cn.taketoday.beans.factory.support.RootBeanDefinition;
import cn.taketoday.core.ResolvableType;
import cn.taketoday.javapoet.ClassName;
import cn.taketoday.javapoet.CodeBlock;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import java.util.function.Predicate;
import javax.lang.model.element.Modifier;

class ScopedProxyBeanRegistrationAotProcessor
implements BeanRegistrationAotProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ScopedProxyBeanRegistrationAotProcessor.class);

    ScopedProxyBeanRegistrationAotProcessor() {
    }

    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        Class beanClass = registeredBean.getBeanClass();
        if (beanClass.equals(ScopedProxyFactoryBean.class)) {
            String targetBeanName = this.getTargetBeanName((BeanDefinition)registeredBean.getMergedBeanDefinition());
            BeanDefinition targetBeanDefinition = this.getTargetBeanDefinition(registeredBean.getBeanFactory(), targetBeanName);
            if (targetBeanDefinition == null) {
                logger.warn("Could not handle {}: no target bean definition found with name {}", (Object)ScopedProxyFactoryBean.class.getSimpleName(), (Object)targetBeanName);
                return null;
            }
            return BeanRegistrationAotContribution.withCustomCodeFragments(codeFragments -> new ScopedProxyBeanRegistrationCodeFragments((BeanRegistrationCodeFragments)codeFragments, registeredBean, targetBeanName, targetBeanDefinition));
        }
        return null;
    }

    @Nullable
    private String getTargetBeanName(BeanDefinition beanDefinition) {
        String targetBeanName;
        Object value = beanDefinition.getPropertyValues().getPropertyValue("targetBeanName");
        return value instanceof String ? (targetBeanName = (String)value) : null;
    }

    @Nullable
    private BeanDefinition getTargetBeanDefinition(ConfigurableBeanFactory beanFactory, @Nullable String targetBeanName) {
        if (targetBeanName != null && beanFactory.containsBean(targetBeanName)) {
            return beanFactory.getMergedBeanDefinition(targetBeanName);
        }
        return null;
    }

    private static class ScopedProxyBeanRegistrationCodeFragments
    extends BeanRegistrationCodeFragmentsDecorator {
        private static final String REGISTERED_BEAN_PARAMETER_NAME = "registeredBean";
        private final RegisteredBean registeredBean;
        private final String targetBeanName;
        private final BeanDefinition targetBeanDefinition;

        ScopedProxyBeanRegistrationCodeFragments(BeanRegistrationCodeFragments delegate, RegisteredBean registeredBean, String targetBeanName, BeanDefinition targetBeanDefinition) {
            super(delegate);
            this.registeredBean = registeredBean;
            this.targetBeanName = targetBeanName;
            this.targetBeanDefinition = targetBeanDefinition;
        }

        public ClassName getTarget(RegisteredBean registeredBean) {
            return ClassName.get((Class)this.targetBeanDefinition.getResolvableType().toClass());
        }

        public CodeBlock generateNewBeanDefinitionCode(GenerationContext generationContext, ResolvableType beanType, BeanRegistrationCode beanRegistrationCode) {
            return super.generateNewBeanDefinitionCode(generationContext, this.targetBeanDefinition.getResolvableType(), beanRegistrationCode);
        }

        public CodeBlock generateSetBeanDefinitionPropertiesCode(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode, RootBeanDefinition beanDefinition, Predicate<String> attributeFilter) {
            RootBeanDefinition processedBeanDefinition = new RootBeanDefinition(beanDefinition);
            processedBeanDefinition.setTargetType(this.targetBeanDefinition.getResolvableType());
            processedBeanDefinition.getPropertyValues().remove("targetBeanName");
            return super.generateSetBeanDefinitionPropertiesCode(generationContext, beanRegistrationCode, processedBeanDefinition, attributeFilter);
        }

        public CodeBlock generateInstanceSupplierCode(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode, boolean allowDirectSupplierShortcut) {
            GeneratedMethod generatedMethod = beanRegistrationCode.getMethods().add("getScopedProxyInstance", method -> {
                method.addJavadoc("Create the scoped proxy bean instance for '$L'.", new Object[]{this.registeredBean.getBeanName()});
                method.addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC});
                method.returns(ScopedProxyFactoryBean.class);
                method.addParameter(RegisteredBean.class, REGISTERED_BEAN_PARAMETER_NAME, new Modifier[0]);
                method.addStatement("$T factory = new $T()", new Object[]{ScopedProxyFactoryBean.class, ScopedProxyFactoryBean.class});
                method.addStatement("factory.setTargetBeanName($S)", new Object[]{this.targetBeanName});
                method.addStatement("factory.setBeanFactory($L.getBeanFactory())", new Object[]{REGISTERED_BEAN_PARAMETER_NAME});
                method.addStatement("return factory", new Object[0]);
            });
            return CodeBlock.of((String)"$T.of($L)", (Object[])new Object[]{InstanceSupplier.class, generatedMethod.toMethodReference().toCodeBlock()});
        }
    }
}

