/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.interceptor;

import cn.taketoday.aop.interceptor.AbstractTraceInterceptor;
import cn.taketoday.lang.Assert;
import cn.taketoday.logging.Logger;
import org.aopalliance.intercept.MethodInvocation;

public class SimpleTraceInterceptor
extends AbstractTraceInterceptor {
    public SimpleTraceInterceptor() {
    }

    public SimpleTraceInterceptor(boolean useDynamicLogger) {
        this.setUseDynamicLogger(useDynamicLogger);
    }

    @Override
    protected Object invokeUnderTrace(MethodInvocation invocation, Logger logger) throws Throwable {
        String invocationDescription = this.getInvocationDescription(invocation);
        this.writeToLog(logger, "Entering " + invocationDescription);
        try {
            Object rval = invocation.proceed();
            this.writeToLog(logger, "Exiting " + invocationDescription);
            return rval;
        }
        catch (Throwable ex) {
            this.writeToLog(logger, "Exception thrown in " + invocationDescription, ex);
            throw ex;
        }
    }

    protected String getInvocationDescription(MethodInvocation invocation) {
        Object target = invocation.getThis();
        Assert.state((target != null ? 1 : 0) != 0, (String)"Target must not be null");
        String className = target.getClass().getName();
        return "method '" + invocation.getMethod().getName() + "' of class [" + className + "]";
    }
}

