/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.interceptor;

import cn.taketoday.aop.Advisor;
import cn.taketoday.aop.ProxyMethodInvocation;
import cn.taketoday.aop.interceptor.ExposeInvocationInterceptor;
import cn.taketoday.aop.support.DefaultIntroductionAdvisor;
import cn.taketoday.aop.support.DefaultPointcutAdvisor;
import cn.taketoday.aop.support.DelegatingIntroductionInterceptor;
import cn.taketoday.beans.factory.NamedBean;
import cn.taketoday.lang.Nullable;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public abstract class ExposeBeanNameAdvisors {
    private static final String BEAN_NAME_ATTRIBUTE = ExposeBeanNameAdvisors.class.getName() + ".BEAN_NAME";

    public static String getBeanName() throws IllegalStateException {
        return ExposeBeanNameAdvisors.getBeanName(ExposeInvocationInterceptor.currentInvocation());
    }

    public static String getBeanName(MethodInvocation mi) throws IllegalStateException {
        if (!(mi instanceof ProxyMethodInvocation)) {
            throw new IllegalArgumentException("MethodInvocation is not a ProxyMethodInvocation: " + mi);
        }
        ProxyMethodInvocation pmi = (ProxyMethodInvocation)mi;
        String beanName = (String)pmi.getAttribute(BEAN_NAME_ATTRIBUTE);
        if (beanName == null) {
            throw new IllegalStateException("Cannot get bean name; not set on MethodInvocation: " + mi);
        }
        return beanName;
    }

    public static Advisor createAdvisorWithoutIntroduction(String beanName) {
        return new DefaultPointcutAdvisor(new ExposeBeanNameInterceptor(beanName));
    }

    public static Advisor createAdvisorIntroducingNamedBean(String beanName) {
        return new DefaultIntroductionAdvisor(new ExposeBeanNameIntroduction(beanName));
    }

    private record ExposeBeanNameInterceptor(String beanName) implements MethodInterceptor
    {
        @Override
        @Nullable
        public Object invoke(MethodInvocation mi) throws Throwable {
            if (!(mi instanceof ProxyMethodInvocation)) {
                throw new IllegalStateException("MethodInvocation is not a ProxyMethodInvocation: " + mi);
            }
            ProxyMethodInvocation pmi = (ProxyMethodInvocation)mi;
            pmi.setAttribute(BEAN_NAME_ATTRIBUTE, this.beanName);
            return mi.proceed();
        }
    }

    private static class ExposeBeanNameIntroduction
    extends DelegatingIntroductionInterceptor
    implements NamedBean {
        private static final long serialVersionUID = 1L;
        private final String beanName;

        public ExposeBeanNameIntroduction(String beanName) {
            this.beanName = beanName;
        }

        @Override
        @Nullable
        public Object invoke(MethodInvocation mi) throws Throwable {
            if (!(mi instanceof ProxyMethodInvocation)) {
                throw new IllegalStateException("MethodInvocation is not a ProxyMethodInvocation: " + mi);
            }
            ProxyMethodInvocation pmi = (ProxyMethodInvocation)mi;
            pmi.setAttribute(BEAN_NAME_ATTRIBUTE, this.beanName);
            return super.invoke(mi);
        }

        public String getBeanName() {
            return this.beanName;
        }
    }
}

