/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.interceptor;

import cn.taketoday.aop.interceptor.AsyncUncaughtExceptionHandler;
import cn.taketoday.aop.interceptor.SimpleAsyncUncaughtExceptionHandler;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryAware;
import cn.taketoday.beans.factory.NoSuchBeanDefinitionException;
import cn.taketoday.beans.factory.NoUniqueBeanDefinitionException;
import cn.taketoday.beans.factory.annotation.BeanFactoryAnnotationUtils;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.beans.factory.config.EmbeddedValueResolver;
import cn.taketoday.core.StringValueResolver;
import cn.taketoday.core.task.AsyncListenableTaskExecutor;
import cn.taketoday.core.task.AsyncTaskExecutor;
import cn.taketoday.core.task.TaskExecutor;
import cn.taketoday.core.task.support.TaskExecutorAdapter;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.ReflectionUtils;
import cn.taketoday.util.StringUtils;
import cn.taketoday.util.concurrent.ListenableFuture;
import cn.taketoday.util.function.SingletonSupplier;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.Supplier;

public abstract class AsyncExecutionAspectSupport
implements BeanFactoryAware {
    private static final Logger log = LoggerFactory.getLogger(AsyncExecutionAspectSupport.class);
    public static final String DEFAULT_TASK_EXECUTOR_BEAN_NAME = "taskExecutor";
    @Nullable
    private BeanFactory beanFactory;
    private SingletonSupplier<Executor> defaultExecutor;
    private SingletonSupplier<AsyncUncaughtExceptionHandler> exceptionHandler;
    private final ConcurrentHashMap<Method, AsyncTaskExecutor> executors = new ConcurrentHashMap(16);
    @Nullable
    private StringValueResolver embeddedValueResolver;

    public AsyncExecutionAspectSupport(@Nullable Executor defaultExecutor) {
        this.defaultExecutor = new SingletonSupplier((Object)defaultExecutor, () -> this.getDefaultExecutor(this.beanFactory));
        this.exceptionHandler = SingletonSupplier.from(SimpleAsyncUncaughtExceptionHandler::new);
    }

    public AsyncExecutionAspectSupport(@Nullable Executor defaultExecutor, AsyncUncaughtExceptionHandler exceptionHandler) {
        this.defaultExecutor = new SingletonSupplier((Object)defaultExecutor, () -> this.getDefaultExecutor(this.beanFactory));
        this.exceptionHandler = SingletonSupplier.valueOf((Object)exceptionHandler);
    }

    public void configure(@Nullable Supplier<Executor> defaultExecutor, @Nullable Supplier<AsyncUncaughtExceptionHandler> exceptionHandler) {
        this.defaultExecutor = new SingletonSupplier(defaultExecutor, () -> this.getDefaultExecutor(this.beanFactory));
        this.exceptionHandler = new SingletonSupplier(exceptionHandler, SimpleAsyncUncaughtExceptionHandler::new);
    }

    public void setExecutor(Executor defaultExecutor) {
        this.defaultExecutor = SingletonSupplier.valueOf((Object)defaultExecutor);
    }

    public void setExceptionHandler(AsyncUncaughtExceptionHandler exceptionHandler) {
        this.exceptionHandler = SingletonSupplier.valueOf((Object)exceptionHandler);
    }

    public void setBeanFactory(@Nullable BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory configurableBeanFactory = (ConfigurableBeanFactory)beanFactory;
            this.embeddedValueResolver = new EmbeddedValueResolver(configurableBeanFactory);
        }
    }

    @Nullable
    protected AsyncTaskExecutor determineAsyncExecutor(Method method) {
        AsyncTaskExecutor executor = this.executors.get(method);
        if (executor == null) {
            TaskExecutorAdapter taskExecutorAdapter;
            Executor targetExecutor;
            String qualifier = this.getExecutorQualifier(method);
            if (this.embeddedValueResolver != null && StringUtils.isNotEmpty((CharSequence)qualifier)) {
                qualifier = this.embeddedValueResolver.resolveStringValue(qualifier);
            }
            if ((targetExecutor = StringUtils.isNotEmpty((CharSequence)qualifier) ? this.findQualifiedExecutor(this.beanFactory, qualifier) : (Executor)this.defaultExecutor.get()) == null) {
                return null;
            }
            if (targetExecutor instanceof AsyncTaskExecutor) {
                AsyncTaskExecutor asyncTaskExecutor = (AsyncTaskExecutor)targetExecutor;
                taskExecutorAdapter = asyncTaskExecutor;
            } else {
                taskExecutorAdapter = new TaskExecutorAdapter(targetExecutor);
            }
            executor = taskExecutorAdapter;
            this.executors.put(method, executor);
        }
        return executor;
    }

    @Nullable
    protected abstract String getExecutorQualifier(Method var1);

    @Nullable
    protected Executor findQualifiedExecutor(@Nullable BeanFactory beanFactory, String qualifier) {
        if (beanFactory == null) {
            throw new IllegalStateException("BeanFactory must be set on " + this.getClass().getSimpleName() + " to access qualified executor '" + qualifier + "'");
        }
        if (beanFactory instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory factory = (ConfigurableBeanFactory)beanFactory;
            EmbeddedValueResolver resolver = new EmbeddedValueResolver(factory);
            qualifier = resolver.resolveStringValue(qualifier);
        }
        return (Executor)BeanFactoryAnnotationUtils.qualifiedBeanOfType((BeanFactory)beanFactory, Executor.class, (String)qualifier);
    }

    @Nullable
    protected Executor getDefaultExecutor(@Nullable BeanFactory beanFactory) {
        if (beanFactory != null) {
            try {
                return (Executor)beanFactory.getBean(TaskExecutor.class);
            }
            catch (NoUniqueBeanDefinitionException ex) {
                log.debug("Could not find default TaskExecutor bean. Continuing search for an Executor bean named 'taskExecutor'", (Throwable)ex);
                try {
                    return (Executor)beanFactory.getBean(DEFAULT_TASK_EXECUTOR_BEAN_NAME, Executor.class);
                }
                catch (NoSuchBeanDefinitionException ex2) {
                    if (log.isInfoEnabled()) {
                        log.info("More than one TaskExecutor bean found within the context, and none is named 'taskExecutor'. Mark one of them as primary or name it 'taskExecutor' (possibly as an alias) in order to use it for async processing: {}", (Object)ex.getBeanNamesFound());
                    }
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                log.debug("Could not find default TaskExecutor bean. Continuing search for an Executor bean named 'taskExecutor'", (Throwable)ex);
                try {
                    return (Executor)beanFactory.getBean(DEFAULT_TASK_EXECUTOR_BEAN_NAME, Executor.class);
                }
                catch (NoSuchBeanDefinitionException ex2) {
                    log.info("No task executor bean found for async processing: no bean of type TaskExecutor and no bean named 'taskExecutor' either");
                }
            }
        }
        return null;
    }

    @Nullable
    protected Object doSubmit(Callable<Object> task, AsyncTaskExecutor executor, Class<?> returnType) {
        if (CompletableFuture.class.isAssignableFrom(returnType)) {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    return task.call();
                }
                catch (Throwable ex) {
                    throw new CompletionException(ex);
                }
            }, (Executor)executor);
        }
        if (ListenableFuture.class.isAssignableFrom(returnType)) {
            return ((AsyncListenableTaskExecutor)executor).submitListenable(task);
        }
        if (Future.class.isAssignableFrom(returnType)) {
            return executor.submit(task);
        }
        executor.submit(task);
        return null;
    }

    public void handleError(Throwable ex, Method method, Object ... params) throws Exception {
        if (Future.class.isAssignableFrom(method.getReturnType())) {
            ReflectionUtils.rethrowException((Throwable)ex);
        } else {
            try {
                ((AsyncUncaughtExceptionHandler)this.exceptionHandler.obtain()).handleUncaughtException(ex, method, params);
            }
            catch (Throwable ex2) {
                log.warn("Exception handler for async method '{}' threw unexpected exception itself", (Object)method.toGenericString(), (Object)ex2);
            }
        }
    }
}

