/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.framework.std;

import cn.taketoday.aop.TargetSource;
import cn.taketoday.aop.framework.AdvisedSupport;
import cn.taketoday.aop.framework.std.DefaultProxyMethodGenerator;
import cn.taketoday.aop.framework.std.GeneratorContext;
import cn.taketoday.aop.framework.std.ProxyMethodGenerator;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.ClassEmitter;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.core.CodeGenerationException;
import cn.taketoday.bytecode.core.EmitUtils;
import cn.taketoday.bytecode.core.MethodInfo;
import cn.taketoday.util.ObjectUtils;
import java.lang.reflect.Member;
import java.lang.reflect.Method;

public class NoneProxyMethodGenerator
implements ProxyMethodGenerator {
    static final MethodSignature targetSourceGetTarget;
    static final Type targetSourceType;

    @Override
    public boolean generate(Method method, GeneratorContext context) {
        AdvisedSupport config = context.getConfig();
        Object[] interceptors = context.getConfig().getInterceptors(method, context.getTargetClass());
        if (ObjectUtils.isEmpty((Object[])interceptors)) {
            TargetSource targetSource = config.getTargetSource();
            if (targetSource.isStatic()) {
                this.invokeStaticTarget(method, context);
            } else {
                this.invokeTargetFromTargetSource(method, context);
            }
            return true;
        }
        return false;
    }

    protected void invokeStaticTarget(Method method, GeneratorContext context) {
        ClassEmitter emitter = context.getClassEmitter();
        int modifiers = DefaultProxyMethodGenerator.excludeAbstractModifiers(method);
        MethodInfo methodInfo = MethodInfo.from((Member)method, (int)modifiers);
        CodeEmitter codeEmitter = EmitUtils.beginMethod((ClassEmitter)emitter, (MethodInfo)methodInfo, (int)modifiers);
        codeEmitter.loadThis();
        codeEmitter.getField("target");
        codeEmitter.loadArgs();
        codeEmitter.invoke(methodInfo);
        codeEmitter.returnValue();
        codeEmitter.unbox_or_zero(Type.fromClass(method.getReturnType()));
        codeEmitter.end_method();
    }

    protected void invokeTargetFromTargetSource(Method method, GeneratorContext context) {
        ClassEmitter emitter = context.getClassEmitter();
        int modifiers = DefaultProxyMethodGenerator.excludeAbstractModifiers(method);
        MethodInfo methodInfo = MethodInfo.from((Member)method, (int)modifiers);
        CodeEmitter codeEmitter = EmitUtils.beginMethod((ClassEmitter)emitter, (MethodInfo)methodInfo, (int)modifiers);
        codeEmitter.loadThis();
        codeEmitter.getField("targetSource");
        codeEmitter.invokeInterface(targetSourceType, targetSourceGetTarget);
        codeEmitter.checkCast(context.getTargetType());
        codeEmitter.loadArgs();
        codeEmitter.invoke(methodInfo);
        codeEmitter.returnValue();
        codeEmitter.unbox_or_zero(Type.fromClass(method.getReturnType()));
        codeEmitter.end_method();
    }

    static {
        targetSourceType = Type.fromClass(TargetSource.class);
        try {
            targetSourceGetTarget = MethodSignature.from((Method)TargetSource.class.getDeclaredMethod("getTarget", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new CodeGenerationException((Throwable)e);
        }
    }
}

