/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.framework.std;

import cn.taketoday.aop.TargetSource;
import cn.taketoday.aop.framework.AdvisedSupport;
import cn.taketoday.aop.framework.StandardProxyInvoker;
import cn.taketoday.aop.framework.TargetInvocation;
import cn.taketoday.aop.framework.std.GeneratorContext;
import cn.taketoday.aop.framework.std.ProxyMethodGenerator;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.Local;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.ClassEmitter;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.core.CodeGenerationException;
import cn.taketoday.bytecode.core.EmitUtils;
import cn.taketoday.bytecode.core.MethodInfo;
import cn.taketoday.util.StringUtils;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;

public class DefaultProxyMethodGenerator
implements ProxyMethodGenerator {
    private static final MethodSignature proceed;
    private static final MethodSignature dynamicProceed;
    private static final MethodSignature staticExposeProceed;
    private static final MethodSignature dynamicExposeProceed;
    private static final MethodSignature dynamicAdvisedProceed;
    private static final Type stdProxyInvoker;
    private static final Type targetInvocationType;

    @Override
    public boolean generate(Method method, GeneratorContext context) {
        List<String> fields = context.getFields();
        String targetInvField = this.putTargetInv(method, context, fields);
        context.addField(targetInvField);
        ClassEmitter classEmitter = context.getClassEmitter();
        classEmitter.declare_field(this.getStaticAccess(), targetInvField, targetInvocationType, null);
        int modifiers = DefaultProxyMethodGenerator.excludeAbstractModifiers(method);
        MethodInfo methodInfo = MethodInfo.from((Member)method, (int)modifiers);
        CodeEmitter codeEmitter = EmitUtils.beginMethod((ClassEmitter)classEmitter, (MethodInfo)methodInfo, (int)modifiers);
        this.generateProxyMethod(method, targetInvField, context, codeEmitter);
        Local returnLocal = null;
        if (method.getReturnType() != Void.TYPE) {
            returnLocal = codeEmitter.newLocal();
            codeEmitter.storeLocal(returnLocal);
        }
        if (returnLocal != null) {
            codeEmitter.loadLocal(returnLocal);
            codeEmitter.unbox_or_zero(Type.fromClass(method.getReturnType()));
        }
        codeEmitter.returnValue();
        codeEmitter.end_method();
        return true;
    }

    protected void generateProxyMethod(Method method, String targetInvField, GeneratorContext context, CodeEmitter codeEmitter) {
        AdvisedSupport config = context.getConfig();
        boolean exposeProxy = config.isExposeProxy();
        boolean isStatic = config.getTargetSource().isStatic();
        boolean opaque = config.isOpaque();
        if (opaque) {
            codeEmitter.loadThis();
            codeEmitter.loadThis();
            if (isStatic) {
                codeEmitter.getField("target");
                codeEmitter.getField(targetInvField);
                this.prepareArgs(method, codeEmitter);
                if (exposeProxy) {
                    codeEmitter.invokeStatic(stdProxyInvoker, staticExposeProceed);
                } else {
                    codeEmitter.invokeStatic(stdProxyInvoker, proceed);
                }
            } else {
                codeEmitter.getField("targetSource");
                codeEmitter.getField(targetInvField);
                this.prepareArgs(method, codeEmitter);
                if (exposeProxy) {
                    codeEmitter.invokeStatic(stdProxyInvoker, dynamicExposeProceed);
                } else {
                    codeEmitter.invokeStatic(stdProxyInvoker, dynamicProceed);
                }
            }
        } else {
            codeEmitter.loadThis();
            codeEmitter.loadThis();
            codeEmitter.getField("config");
            codeEmitter.getField(targetInvField);
            this.prepareArgs(method, codeEmitter);
            codeEmitter.invokeStatic(stdProxyInvoker, dynamicAdvisedProceed);
        }
    }

    protected String putTargetInv(Method method, GeneratorContext context, List<String> fields) {
        String field = method.getName() + StringUtils.generateRandomString((int)4);
        if (fields.contains(field)) {
            return this.putTargetInv(method, context, fields);
        }
        TargetInvocation target = TargetInvocation.getTarget(field);
        if (target != null) {
            return this.putTargetInv(method, context, fields);
        }
        TargetInvocation.putTarget(field, this.getTarget(method, context));
        return field;
    }

    protected int getStaticAccess() {
        return 26;
    }

    protected TargetInvocation getTarget(Method method, GeneratorContext context) {
        return new TargetInvocation(method, context.getTargetClass(), context.getConfig());
    }

    protected void prepareArgs(Method method, CodeEmitter codeEmitter) {
        if (method.getParameterCount() == 0) {
            EmitUtils.loadEmptyArguments((CodeEmitter)codeEmitter);
        } else {
            codeEmitter.loadArgArray();
        }
    }

    static int excludeAbstractModifiers(Method method) {
        int modifiers = method.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            return 1;
        }
        return modifiers;
    }

    static {
        stdProxyInvoker = Type.fromClass(StandardProxyInvoker.class);
        targetInvocationType = Type.fromClass(TargetInvocation.class);
        try {
            Class<StandardProxyInvoker> aClass = StandardProxyInvoker.class;
            proceed = MethodSignature.from((Method)aClass.getMethod("proceed", Object.class, Object.class, TargetInvocation.class, Object[].class));
            dynamicProceed = MethodSignature.from((Method)aClass.getMethod("dynamicProceed", Object.class, TargetSource.class, TargetInvocation.class, Object[].class));
            dynamicExposeProceed = MethodSignature.from((Method)aClass.getMethod("dynamicExposeProceed", Object.class, TargetSource.class, TargetInvocation.class, Object[].class));
            staticExposeProceed = MethodSignature.from((Method)aClass.getMethod("staticExposeProceed", Object.class, Object.class, TargetInvocation.class, Object[].class));
            dynamicAdvisedProceed = MethodSignature.from((Method)aClass.getMethod("dynamicAdvisedProceed", Object.class, AdvisedSupport.class, TargetInvocation.class, Object[].class));
        }
        catch (NoSuchMethodException e) {
            throw new CodeGenerationException((Throwable)e);
        }
    }
}

