/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.framework.autoproxy.target;

import cn.taketoday.aop.AopInfrastructureBean;
import cn.taketoday.aop.TargetSource;
import cn.taketoday.aop.framework.autoproxy.TargetSourceCreator;
import cn.taketoday.aop.target.AbstractBeanFactoryTargetSource;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryAware;
import cn.taketoday.beans.factory.DisposableBean;
import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.beans.factory.support.GenericBeanDefinition;
import cn.taketoday.beans.factory.support.StandardBeanFactory;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import java.util.HashMap;

public abstract class AbstractBeanFactoryTargetSourceCreator
implements TargetSourceCreator,
BeanFactoryAware,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractBeanFactoryTargetSourceCreator.class);
    private ConfigurableBeanFactory beanFactory;
    private final HashMap<String, StandardBeanFactory> internalBeanFactories = new HashMap();

    public final void setBeanFactory(BeanFactory beanFactory) {
        if (!(beanFactory instanceof ConfigurableBeanFactory)) {
            throw new IllegalStateException("Cannot do auto-TargetSource creation with a BeanFactory that doesn't implement ConfigurableBeanFactory: " + beanFactory.getClass());
        }
        this.beanFactory = (ConfigurableBeanFactory)beanFactory;
    }

    protected final BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    @Override
    @Nullable
    public final TargetSource getTargetSource(Class<?> beanClass, String beanName) {
        AbstractBeanFactoryTargetSource targetSource = this.createBeanFactoryTargetSource(beanClass, beanName);
        if (targetSource == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Configuring AbstractBeanFactoryBasedTargetSource: {}", (Object)targetSource);
        }
        StandardBeanFactory internalBeanFactory = this.getInternalBeanFactoryForBean(beanName);
        BeanDefinition bd = this.beanFactory.getMergedBeanDefinition(beanName);
        GenericBeanDefinition bdCopy = new GenericBeanDefinition(bd);
        if (this.isPrototypeBased()) {
            bdCopy.setScope("prototype");
        }
        internalBeanFactory.registerBeanDefinition(beanName, (BeanDefinition)bdCopy);
        targetSource.setTargetBeanName(beanName);
        targetSource.setBeanFactory((BeanFactory)internalBeanFactory);
        return targetSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StandardBeanFactory getInternalBeanFactoryForBean(String beanName) {
        HashMap<String, StandardBeanFactory> hashMap = this.internalBeanFactories;
        synchronized (hashMap) {
            return this.internalBeanFactories.computeIfAbsent(beanName, name -> this.buildInternalBeanFactory(this.beanFactory));
        }
    }

    protected StandardBeanFactory buildInternalBeanFactory(ConfigurableBeanFactory containingFactory) {
        StandardBeanFactory internalBeanFactory = new StandardBeanFactory((BeanFactory)containingFactory);
        internalBeanFactory.copyConfigurationFrom(containingFactory);
        internalBeanFactory.getBeanPostProcessors().removeIf(beanPostProcessor -> beanPostProcessor instanceof AopInfrastructureBean);
        return internalBeanFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        HashMap<String, StandardBeanFactory> hashMap = this.internalBeanFactories;
        synchronized (hashMap) {
            for (StandardBeanFactory bf : this.internalBeanFactories.values()) {
                bf.destroySingletons();
            }
        }
    }

    protected boolean isPrototypeBased() {
        return true;
    }

    @Nullable
    protected abstract AbstractBeanFactoryTargetSource createBeanFactoryTargetSource(Class<?> var1, String var2);
}

