/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.framework.autoproxy;

import cn.taketoday.aop.Advisor;
import cn.taketoday.beans.factory.BeanCreationException;
import cn.taketoday.beans.factory.BeanCurrentlyInCreationException;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryUtils;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class BeanFactoryAdvisorRetriever {
    private static final Logger logger = LoggerFactory.getLogger(BeanFactoryAdvisorRetriever.class);
    private final ConfigurableBeanFactory beanFactory;
    @Nullable
    private volatile Set<String> cachedAdvisorBeanNames;

    public BeanFactoryAdvisorRetriever(ConfigurableBeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"ConfigurableBeanFactory is required");
        this.beanFactory = beanFactory;
    }

    public List<Advisor> retrieveAdvisorBeans() {
        Set advisorNames = this.cachedAdvisorBeanNames;
        if (advisorNames == null) {
            this.cachedAdvisorBeanNames = advisorNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((BeanFactory)this.beanFactory, Advisor.class, (boolean)true, (boolean)false);
        }
        if (advisorNames.isEmpty()) {
            return new ArrayList<Advisor>();
        }
        ArrayList<Advisor> advisors = new ArrayList<Advisor>();
        for (String name : advisorNames) {
            if (!this.isEligibleBean(name)) continue;
            if (this.beanFactory.isCurrentlyInCreation(name)) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Skipping currently created advisor '{}'", (Object)name);
                continue;
            }
            try {
                advisors.add((Advisor)this.beanFactory.getBean(name, Advisor.class));
            }
            catch (BeanCreationException ex) {
                BeanCurrentlyInCreationException bce;
                String bceBeanName;
                Throwable rootCause = ex.getMostSpecificCause();
                if (rootCause instanceof BeanCurrentlyInCreationException && (bceBeanName = (bce = (BeanCurrentlyInCreationException)rootCause).getBeanName()) != null && this.beanFactory.isCurrentlyInCreation(bceBeanName)) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("Skipping advisor '{}' with dependency on currently created bean: {}", (Object)name, (Object)ex.getMessage());
                    continue;
                }
                throw ex;
            }
        }
        return advisors;
    }

    protected boolean isEligibleBean(String beanName) {
        return true;
    }
}

