/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.framework.autoproxy;

import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.core.Conventions;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.StringUtils;

public abstract class AutoProxyUtils {
    public static final String PRESERVE_TARGET_CLASS_ATTRIBUTE = Conventions.getQualifiedAttributeName(AutoProxyUtils.class, (String)"preserveTargetClass");
    public static final String ORIGINAL_TARGET_CLASS_ATTRIBUTE = Conventions.getQualifiedAttributeName(AutoProxyUtils.class, (String)"originalTargetClass");

    public static boolean shouldProxyTargetClass(ConfigurableBeanFactory beanFactory, @Nullable String beanName) {
        if (beanName != null && beanFactory.containsBeanDefinition(beanName)) {
            BeanDefinition bd = beanFactory.getBeanDefinition(beanName);
            return Boolean.TRUE.equals(bd.getAttribute(PRESERVE_TARGET_CLASS_ATTRIBUTE));
        }
        return false;
    }

    @Nullable
    public static Class<?> determineTargetClass(ConfigurableBeanFactory beanFactory, @Nullable String beanName) {
        BeanDefinition bd;
        Class targetClass;
        if (beanName == null) {
            return null;
        }
        if (beanFactory.containsBeanDefinition(beanName) && (targetClass = (Class)(bd = beanFactory.getMergedBeanDefinition(beanName)).getAttribute(ORIGINAL_TARGET_CLASS_ATTRIBUTE)) != null) {
            return targetClass;
        }
        return beanFactory.getType(beanName);
    }

    static void exposeTargetClass(ConfigurableBeanFactory beanFactory, @Nullable String beanName, Class<?> targetClass) {
        if (beanName != null && beanFactory.containsBeanDefinition(beanName)) {
            beanFactory.getMergedBeanDefinition(beanName).setAttribute(ORIGINAL_TARGET_CLASS_ATTRIBUTE, targetClass);
        }
    }

    static boolean isOriginalInstance(String beanName, Class<?> beanClass) {
        if (StringUtils.isEmpty((CharSequence)beanName) || beanName.length() != beanClass.getName().length() + ".ORIGINAL".length()) {
            return false;
        }
        return beanName.startsWith(beanClass.getName()) && beanName.endsWith(".ORIGINAL");
    }
}

