/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.framework.autoproxy;

import cn.taketoday.aop.Advisor;
import cn.taketoday.aop.AopInfrastructureBean;
import cn.taketoday.aop.Pointcut;
import cn.taketoday.aop.TargetSource;
import cn.taketoday.aop.framework.ProxyCreator;
import cn.taketoday.aop.framework.ProxyFactory;
import cn.taketoday.aop.framework.ProxyProcessorSupport;
import cn.taketoday.aop.framework.adapter.AdvisorAdapterRegistry;
import cn.taketoday.aop.framework.adapter.DefaultAdvisorAdapterRegistry;
import cn.taketoday.aop.framework.autoproxy.AutoProxyUtils;
import cn.taketoday.aop.framework.autoproxy.TargetSourceCreator;
import cn.taketoday.aop.target.EmptyTargetSource;
import cn.taketoday.aop.target.SingletonTargetSource;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryAware;
import cn.taketoday.beans.factory.FactoryBean;
import cn.taketoday.beans.factory.InitializationBeanPostProcessor;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.beans.factory.config.SmartInstantiationAwareBeanPostProcessor;
import cn.taketoday.core.SmartClassLoader;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.aop.Advice;

public abstract class AbstractAutoProxyCreator
extends ProxyProcessorSupport
implements SmartInstantiationAwareBeanPostProcessor,
BeanFactoryAware,
AopInfrastructureBean,
ProxyCreator,
InitializationBeanPostProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(AbstractAutoProxyCreator.class);
    @Nullable
    protected static final Object[] DO_NOT_PROXY = null;
    protected static final Object[] PROXY_WITHOUT_ADDITIONAL_INTERCEPTORS = new Object[0];
    @Nullable
    private BeanFactory beanFactory;
    private boolean freezeProxy = false;
    @Nullable
    private transient TargetSourceCreator[] customTargetSourceCreators;
    private String[] interceptorNames = new String[0];
    private boolean applyCommonInterceptorsFirst = true;
    private AdvisorAdapterRegistry advisorAdapterRegistry = DefaultAdvisorAdapterRegistry.getInstance();
    private final Set<String> targetSourcedBeans = Collections.newSetFromMap(new ConcurrentHashMap(16));
    private final ConcurrentHashMap<Object, Object> earlyBeanReferences = new ConcurrentHashMap(16);
    private final ConcurrentHashMap<Object, Boolean> advisedBeans = new ConcurrentHashMap(256);
    private final ConcurrentHashMap<Object, Class<?>> proxyTypes = new ConcurrentHashMap(16);

    public void setCustomTargetSourceCreators(TargetSourceCreator ... customTargetSourceCreators) {
        this.customTargetSourceCreators = customTargetSourceCreators;
    }

    public void setAdvisorAdapterRegistry(AdvisorAdapterRegistry advisorAdapterRegistry) {
        Assert.notNull((Object)advisorAdapterRegistry, (String)"AdvisorAdapterRegistry is required");
        this.advisorAdapterRegistry = advisorAdapterRegistry;
    }

    @Override
    public void setFrozen(boolean frozen) {
        this.freezeProxy = frozen;
    }

    @Override
    public boolean isFrozen() {
        return this.freezeProxy;
    }

    public void setInterceptorNames(String ... interceptorNames) {
        this.interceptorNames = interceptorNames;
    }

    public void setApplyCommonInterceptorsFirst(boolean applyCommonInterceptorsFirst) {
        this.applyCommonInterceptorsFirst = applyCommonInterceptorsFirst;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Nullable
    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    @Nullable
    public Object postProcessBeforeInstantiation(Class<?> beanClass, String beanName) {
        TargetSource targetSource;
        Object cacheKey = this.getCacheKey(beanClass, beanName);
        if (StringUtils.isEmpty((CharSequence)beanName) || !this.targetSourcedBeans.contains(beanName)) {
            if (this.advisedBeans.containsKey(cacheKey)) {
                return null;
            }
            if (this.isInfrastructureClass(beanClass) || this.shouldSkip(beanClass, beanName)) {
                this.advisedBeans.put(cacheKey, Boolean.FALSE);
                return null;
            }
        }
        if ((targetSource = this.getCustomTargetSource(beanClass, beanName)) != null) {
            if (StringUtils.isNotEmpty((CharSequence)beanName)) {
                this.targetSourcedBeans.add(beanName);
            }
            Object[] specificInterceptors = this.getAdvicesAndAdvisorsForBean(beanClass, beanName, targetSource);
            Object proxy = this.createProxy(beanClass, beanName, specificInterceptors, targetSource);
            this.proxyTypes.put(cacheKey, proxy.getClass());
            return proxy;
        }
        return null;
    }

    @Nullable
    protected TargetSource getCustomTargetSource(Class<?> beanClass, String beanName) {
        if (this.customTargetSourceCreators != null) {
            for (TargetSourceCreator creator : this.customTargetSourceCreators) {
                TargetSource source = creator.getTargetSource(beanClass, beanName);
                if (source == null) continue;
                if (log.isTraceEnabled()) {
                    log.trace("TargetSourceCreator [{}] found custom TargetSource for bean with name '{}'", (Object)creator, (Object)beanName);
                }
                return source;
            }
        }
        return null;
    }

    @Nullable
    public Class<?> predictBeanType(Class<?> beanClass, String beanName) {
        if (this.proxyTypes.isEmpty()) {
            return null;
        }
        Object cacheKey = this.getCacheKey(beanClass, beanName);
        return this.proxyTypes.get(cacheKey);
    }

    public Class<?> determineBeanType(Class<?> beanClass, String beanName) {
        Object cacheKey = this.getCacheKey(beanClass, beanName);
        Class<?> proxyType = this.proxyTypes.get(cacheKey);
        if (proxyType == null) {
            Object[] specificInterceptors;
            TargetSource targetSource = this.getCustomTargetSource(beanClass, beanName);
            if (targetSource != null) {
                if (StringUtils.isNotEmpty((CharSequence)beanName)) {
                    this.targetSourcedBeans.add(beanName);
                }
            } else {
                targetSource = EmptyTargetSource.forClass(beanClass);
            }
            if ((specificInterceptors = this.getAdvicesAndAdvisorsForBean(beanClass, beanName, targetSource)) != DO_NOT_PROXY) {
                this.advisedBeans.put(cacheKey, Boolean.TRUE);
                proxyType = this.createProxyClass(beanClass, beanName, specificInterceptors, targetSource);
                this.proxyTypes.put(cacheKey, proxyType);
            }
        }
        return proxyType != null ? proxyType : beanClass;
    }

    @Nullable
    public Constructor<?>[] determineCandidateConstructors(Class<?> beanClass, String beanName) {
        return null;
    }

    public Object getEarlyBeanReference(Object bean, String beanName) {
        Object cacheKey = this.getCacheKey(bean.getClass(), beanName);
        this.earlyBeanReferences.put(cacheKey, bean);
        return this.wrapIfNecessary(bean, beanName, cacheKey);
    }

    @Nullable
    public Object postProcessAfterInitialization(@Nullable Object bean, String beanName) {
        Object cacheKey;
        if (bean != null && this.earlyBeanReferences.remove(cacheKey = this.getCacheKey(bean.getClass(), beanName)) != bean) {
            return this.wrapIfNecessary(bean, beanName, cacheKey);
        }
        return bean;
    }

    protected Object getCacheKey(Class<?> beanClass, @Nullable String beanName) {
        if (StringUtils.isNotEmpty((CharSequence)beanName)) {
            return FactoryBean.class.isAssignableFrom(beanClass) ? "&" + beanName : beanName;
        }
        return beanClass;
    }

    protected Object wrapIfNecessary(Object bean, String beanName, Object cacheKey) {
        if (StringUtils.isNotEmpty((CharSequence)beanName) && this.targetSourcedBeans.contains(beanName)) {
            return bean;
        }
        if (Boolean.FALSE.equals(this.advisedBeans.get(cacheKey))) {
            return bean;
        }
        Class<?> beanClass = bean.getClass();
        if (this.isInfrastructureClass(beanClass) || this.shouldSkip(beanClass, beanName)) {
            this.advisedBeans.put(cacheKey, Boolean.FALSE);
            return bean;
        }
        Object[] specificInterceptors = this.getAdvicesAndAdvisorsForBean(beanClass, beanName, null);
        if (specificInterceptors != DO_NOT_PROXY) {
            this.advisedBeans.put(cacheKey, Boolean.TRUE);
            Object proxy = this.createProxy(beanClass, beanName, specificInterceptors, new SingletonTargetSource(bean));
            this.proxyTypes.put(cacheKey, proxy.getClass());
            return proxy;
        }
        this.advisedBeans.put(cacheKey, Boolean.FALSE);
        return bean;
    }

    protected TargetSource getTargetSource(Object bean, String def) {
        TargetSource targetSource = this.getCustomTargetSource(bean.getClass(), def);
        if (targetSource == null) {
            targetSource = new SingletonTargetSource(bean);
        }
        return targetSource;
    }

    protected Object createProxy(Class<?> beanClass, @Nullable String beanName, @Nullable Object[] specificInterceptors, TargetSource targetSource) {
        return this.buildProxy(beanClass, beanName, specificInterceptors, targetSource, false);
    }

    private Class<?> createProxyClass(Class<?> beanClass, @Nullable String beanName, @Nullable Object[] specificInterceptors, TargetSource targetSource) {
        return (Class)this.buildProxy(beanClass, beanName, specificInterceptors, targetSource, true);
    }

    private Object buildProxy(Class<?> beanClass, @Nullable String beanName, @Nullable Object[] specificInterceptors, TargetSource targetSource, boolean classOnly) {
        ClassLoader classLoader;
        Class<?>[] classArray = this.beanFactory;
        if (classArray instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory cbf = (ConfigurableBeanFactory)classArray;
            AutoProxyUtils.exposeTargetClass(cbf, beanName, beanClass);
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.copyFrom(this);
        if (proxyFactory.isProxyTargetClass()) {
            if (Proxy.isProxyClass(beanClass) || ClassUtils.isLambdaClass(beanClass)) {
                for (Class<?> ifc : beanClass.getInterfaces()) {
                    proxyFactory.addInterface(ifc);
                }
            }
        } else if (this.shouldProxyTargetClass(beanClass, beanName)) {
            proxyFactory.setProxyTargetClass(true);
        } else {
            this.evaluateProxyInterfaces(beanClass, proxyFactory);
        }
        Advisor[] advisors = this.buildAdvisors(beanName, specificInterceptors);
        proxyFactory.addAdvisors(advisors);
        proxyFactory.setTargetSource(targetSource);
        this.customizeProxyFactory(proxyFactory);
        proxyFactory.setFrozen(this.freezeProxy);
        if (this.advisorsPreFiltered()) {
            proxyFactory.setPreFiltered(true);
        }
        if ((classLoader = this.getProxyClassLoader()) instanceof SmartClassLoader && classLoader != beanClass.getClassLoader()) {
            classLoader = ((SmartClassLoader)classLoader).getOriginalClassLoader();
        }
        return classOnly ? proxyFactory.getProxyClass(classLoader) : proxyFactory.getProxy(classLoader);
    }

    protected boolean shouldSkip(Class<?> beanClass, String beanName) {
        return false;
    }

    protected boolean isInfrastructureClass(Class<?> beanClass) {
        boolean retVal;
        boolean bl = retVal = Advice.class.isAssignableFrom(beanClass) || Advisor.class.isAssignableFrom(beanClass) || Pointcut.class.isAssignableFrom(beanClass) || AopInfrastructureBean.class.isAssignableFrom(beanClass);
        if (retVal && log.isTraceEnabled()) {
            log.trace("Did not attempt to auto-proxy infrastructure class [{}]", (Object)beanClass.getName());
        }
        return retVal;
    }

    protected boolean shouldProxyTargetClass(Class<?> beanClass, @Nullable String beanName) {
        ConfigurableBeanFactory configurableBeanFactory;
        BeanFactory beanFactory = this.beanFactory;
        return beanFactory instanceof ConfigurableBeanFactory && AutoProxyUtils.shouldProxyTargetClass(configurableBeanFactory = (ConfigurableBeanFactory)beanFactory, beanName);
    }

    protected boolean advisorsPreFiltered() {
        return false;
    }

    protected Advisor[] buildAdvisors(@Nullable String beanName, @Nullable Object[] specificInterceptors) {
        Object[] commonInterceptors = this.resolveInterceptorNames();
        ArrayList<Object> allInterceptors = new ArrayList<Object>();
        if (specificInterceptors != null) {
            if (specificInterceptors.length > 0) {
                allInterceptors.addAll(Arrays.asList(specificInterceptors));
            }
            if (commonInterceptors.length > 0) {
                if (this.applyCommonInterceptorsFirst) {
                    allInterceptors.addAll(0, Arrays.asList(commonInterceptors));
                } else {
                    CollectionUtils.addAll(allInterceptors, (Object[])commonInterceptors);
                }
            }
        }
        if (log.isTraceEnabled()) {
            int nrOfCommonInterceptors = commonInterceptors.length;
            int nrOfSpecificInterceptors = specificInterceptors != null ? specificInterceptors.length : 0;
            log.trace("Creating implicit proxy for bean '{}' with {} common interceptors and {} specific interceptors", new Object[]{beanName, nrOfCommonInterceptors, nrOfSpecificInterceptors});
        }
        Advisor[] advisors = new Advisor[allInterceptors.size()];
        for (int i = 0; i < allInterceptors.size(); ++i) {
            advisors[i] = this.advisorAdapterRegistry.wrap(allInterceptors.get(i));
        }
        return advisors;
    }

    private Advisor[] resolveInterceptorNames() {
        BeanFactory bf = this.beanFactory;
        ConfigurableBeanFactory cbf = bf instanceof ConfigurableBeanFactory ? (ConfigurableBeanFactory)bf : null;
        ArrayList<Advisor> advisors = new ArrayList<Advisor>();
        for (String beanName : this.interceptorNames) {
            if (cbf != null && cbf.isCurrentlyInCreation(beanName)) continue;
            Assert.state((bf != null ? 1 : 0) != 0, (String)"BeanFactory required for resolving interceptor names");
            Object next = bf.getBean(beanName);
            advisors.add(this.advisorAdapterRegistry.wrap(next));
        }
        return advisors.toArray(new Advisor[0]);
    }

    protected void customizeProxyFactory(ProxyFactory proxyFactory) {
    }

    @Nullable
    protected abstract Object[] getAdvicesAndAdvisorsForBean(Class<?> var1, String var2, @Nullable TargetSource var3);
}

