/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.framework.autoproxy;

import cn.taketoday.aop.Advisor;
import cn.taketoday.aop.TargetSource;
import cn.taketoday.aop.framework.autoproxy.AbstractAutoProxyCreator;
import cn.taketoday.aop.framework.autoproxy.BeanFactoryAdvisorRetriever;
import cn.taketoday.aop.framework.autoproxy.ProxyCreationContext;
import cn.taketoday.aop.support.AopUtils;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.core.annotation.AnnotationAwareOrderComparator;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import java.util.List;

public abstract class AbstractAdvisorAutoProxyCreator
extends AbstractAutoProxyCreator {
    @Nullable
    private BeanFactoryAdvisorRetriever advisorRetriever;

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        super.setBeanFactory(beanFactory);
        if (!(beanFactory instanceof ConfigurableBeanFactory)) {
            throw new IllegalArgumentException("AdvisorAutoProxyCreator requires a ConfigurableBeanFactory: " + beanFactory);
        }
        this.initBeanFactory((ConfigurableBeanFactory)beanFactory);
    }

    protected void initBeanFactory(ConfigurableBeanFactory beanFactory) {
        this.advisorRetriever = new BeanFactoryAdvisorRetrieverAdapter(beanFactory);
    }

    @Override
    @Nullable
    protected Object[] getAdvicesAndAdvisorsForBean(Class<?> beanClass, String beanName, @Nullable TargetSource targetSource) {
        List<Advisor> advisors = this.findEligibleAdvisors(beanClass, beanName);
        if (advisors.isEmpty()) {
            return DO_NOT_PROXY;
        }
        return advisors.toArray();
    }

    protected List<Advisor> findEligibleAdvisors(Class<?> beanClass, String beanName) {
        List<Advisor> candidateAdvisors = this.findCandidateAdvisors();
        List<Advisor> eligibleAdvisors = this.findAdvisorsThatCanApply(candidateAdvisors, beanClass, beanName);
        this.extendAdvisors(eligibleAdvisors);
        if (!eligibleAdvisors.isEmpty()) {
            eligibleAdvisors = this.sortAdvisors(eligibleAdvisors);
        }
        return eligibleAdvisors;
    }

    protected List<Advisor> findCandidateAdvisors() {
        Assert.state((this.advisorRetriever != null ? 1 : 0) != 0, (String)"No BeanFactoryAdvisorRetriever available");
        return this.advisorRetriever.retrieveAdvisorBeans();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Advisor> findAdvisorsThatCanApply(List<Advisor> candidateAdvisors, Class<?> beanClass, String beanName) {
        ProxyCreationContext.setCurrentProxiedBeanName(beanName);
        try {
            List<Advisor> list = AopUtils.filterAdvisors(candidateAdvisors, beanClass);
            return list;
        }
        finally {
            ProxyCreationContext.setCurrentProxiedBeanName(null);
        }
    }

    protected boolean isEligibleAdvisorBean(String beanName) {
        return true;
    }

    protected List<Advisor> sortAdvisors(List<Advisor> advisors) {
        AnnotationAwareOrderComparator.sort(advisors);
        return advisors;
    }

    protected void extendAdvisors(List<Advisor> candidateAdvisors) {
    }

    @Override
    protected boolean advisorsPreFiltered() {
        return true;
    }

    private class BeanFactoryAdvisorRetrieverAdapter
    extends BeanFactoryAdvisorRetriever {
        public BeanFactoryAdvisorRetrieverAdapter(ConfigurableBeanFactory beanFactory) {
            super(beanFactory);
        }

        @Override
        protected boolean isEligibleBean(String beanName) {
            return AbstractAdvisorAutoProxyCreator.this.isEligibleAdvisorBean(beanName);
        }
    }
}

