/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.framework.adapter;

import cn.taketoday.aop.Advisor;
import cn.taketoday.aop.framework.adapter.AdvisorAdapter;
import cn.taketoday.aop.framework.adapter.AdvisorAdapterRegistry;
import cn.taketoday.aop.framework.adapter.AfterReturningAdviceAdapter;
import cn.taketoday.aop.framework.adapter.MethodBeforeAdviceAdapter;
import cn.taketoday.aop.framework.adapter.ThrowsAdviceAdapter;
import cn.taketoday.aop.framework.adapter.UnknownAdviceTypeException;
import cn.taketoday.aop.support.DefaultPointcutAdvisor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;

public class DefaultAdvisorAdapterRegistry
implements AdvisorAdapterRegistry,
Serializable {
    private static final long serialVersionUID = 1L;
    private static AdvisorAdapterRegistry instance = new DefaultAdvisorAdapterRegistry();
    private final ArrayList<AdvisorAdapter> adapters = new ArrayList(3);

    public DefaultAdvisorAdapterRegistry() {
        this.registerAdvisorAdapter(new MethodBeforeAdviceAdapter());
        this.registerAdvisorAdapter(new AfterReturningAdviceAdapter());
        this.registerAdvisorAdapter(new ThrowsAdviceAdapter());
    }

    @Override
    public Advisor wrap(Object adviceObject) throws UnknownAdviceTypeException {
        if (adviceObject instanceof Advisor) {
            return (Advisor)adviceObject;
        }
        if (!(adviceObject instanceof Advice)) {
            throw new UnknownAdviceTypeException(adviceObject);
        }
        Advice advice = (Advice)adviceObject;
        if (advice instanceof MethodInterceptor) {
            return new DefaultPointcutAdvisor(advice);
        }
        for (AdvisorAdapter adapter : this.adapters) {
            if (!adapter.supportsAdvice(advice)) continue;
            return new DefaultPointcutAdvisor(advice);
        }
        throw new UnknownAdviceTypeException(advice);
    }

    @Override
    public List<MethodInterceptor> getInterceptors(Advisor advisor) throws UnknownAdviceTypeException {
        ArrayList<MethodInterceptor> interceptors = new ArrayList<MethodInterceptor>(3);
        Advice advice = advisor.getAdvice();
        if (advice instanceof MethodInterceptor) {
            interceptors.add((MethodInterceptor)advice);
        }
        for (AdvisorAdapter adapter : this.adapters) {
            if (!adapter.supportsAdvice(advice)) continue;
            interceptors.add(adapter.getInterceptor(advisor));
        }
        if (interceptors.isEmpty()) {
            throw new UnknownAdviceTypeException(advisor.getAdvice());
        }
        return interceptors;
    }

    @Override
    public void registerAdvisorAdapter(AdvisorAdapter adapter) {
        this.adapters.add(adapter);
    }

    public static AdvisorAdapterRegistry getInstance() {
        return instance;
    }

    static void reset() {
        instance = new DefaultAdvisorAdapterRegistry();
    }
}

